/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreNumericRangeQuery;
import com.couchbase.client.java.search.SearchQuery;

public class NumericRangeQuery
extends SearchQuery {
    private Double min;
    private Double max;
    private Boolean inclusiveMin = null;
    private Boolean inclusiveMax = null;
    private String field;

    public NumericRangeQuery min(double min, boolean inclusive) {
        this.min = min;
        this.inclusiveMin = inclusive;
        return this;
    }

    public NumericRangeQuery min(double min) {
        this.min = min;
        this.inclusiveMin = null;
        return this;
    }

    public NumericRangeQuery max(double max, boolean inclusive) {
        this.max = max;
        this.inclusiveMax = inclusive;
        return this;
    }

    public NumericRangeQuery max(double max) {
        this.max = max;
        this.inclusiveMax = null;
        return this;
    }

    public NumericRangeQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public NumericRangeQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    public CoreSearchQuery toCore() {
        return new CoreNumericRangeQuery(this.min, this.max, this.inclusiveMin, this.inclusiveMax, this.field, this.boost);
    }
}

