/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.getmulti;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.CoreTransactionOptionalGetMultiResult;
import com.couchbase.client.core.transaction.components.CoreTransactionGetMultiSpec;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.transactions.getmulti.TransactionGetMultiReplicasFromPreferredServerGroupResult;
import com.couchbase.client.java.transactions.getmulti.TransactionGetMultiReplicasFromPreferredServerGroupSpec;
import com.couchbase.client.java.transactions.getmulti.TransactionGetMultiReplicasFromPreferredServerGroupSpecResult;
import com.couchbase.client.java.transactions.getmulti.TransactionGetMultiResult;
import com.couchbase.client.java.transactions.getmulti.TransactionGetMultiSpec;
import com.couchbase.client.java.transactions.getmulti.TransactionGetMultiSpecResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Stability.Internal
public class TransactionGetMultiUtil {
    private TransactionGetMultiUtil() {
    }

    public static List<CoreTransactionGetMultiSpec> convert(List<TransactionGetMultiSpec> specs) {
        ArrayList<CoreTransactionGetMultiSpec> coreSpecs = new ArrayList<CoreTransactionGetMultiSpec>(specs.size());
        for (int i = 0; i < specs.size(); ++i) {
            TransactionGetMultiSpec spec = specs.get(i);
            Collection collection = spec.collection();
            CollectionIdentifier collId = new CollectionIdentifier(collection.bucketName(), Optional.of(collection.scopeName()), Optional.of(collection.name()));
            coreSpecs.add(new CoreTransactionGetMultiSpec(collId, spec.id(), i));
        }
        return coreSpecs;
    }

    public static TransactionGetMultiResult convert(List<CoreTransactionOptionalGetMultiResult> result, List<TransactionGetMultiSpec> specs, JsonSerializer serializer) {
        ArrayList<TransactionGetMultiSpecResult> results = new ArrayList<TransactionGetMultiSpecResult>(result.size());
        for (int i = 0; i < result.size(); ++i) {
            TransactionGetMultiSpec spec = specs.get(i);
            results.add(new TransactionGetMultiSpecResult(spec, result.get((int)i).internal, serializer, spec.transcoder()));
        }
        return new TransactionGetMultiResult(results);
    }

    public static List<CoreTransactionGetMultiSpec> convertReplica(List<TransactionGetMultiReplicasFromPreferredServerGroupSpec> specs) {
        ArrayList<CoreTransactionGetMultiSpec> coreSpecs = new ArrayList<CoreTransactionGetMultiSpec>(specs.size());
        for (int i = 0; i < specs.size(); ++i) {
            TransactionGetMultiReplicasFromPreferredServerGroupSpec spec = specs.get(i);
            Collection collection = spec.collection();
            CollectionIdentifier collId = new CollectionIdentifier(collection.bucketName(), Optional.of(collection.scopeName()), Optional.of(collection.name()));
            coreSpecs.add(new CoreTransactionGetMultiSpec(collId, spec.id(), i));
        }
        return coreSpecs;
    }

    public static TransactionGetMultiReplicasFromPreferredServerGroupResult convertReplica(List<CoreTransactionOptionalGetMultiResult> result, List<TransactionGetMultiReplicasFromPreferredServerGroupSpec> specs, JsonSerializer serializer) {
        ArrayList<TransactionGetMultiReplicasFromPreferredServerGroupSpecResult> results = new ArrayList<TransactionGetMultiReplicasFromPreferredServerGroupSpecResult>(result.size());
        for (int i = 0; i < result.size(); ++i) {
            TransactionGetMultiReplicasFromPreferredServerGroupSpec spec = specs.get(i);
            results.add(new TransactionGetMultiReplicasFromPreferredServerGroupSpecResult(spec, result.get((int)i).internal, serializer, spec.transcoder()));
        }
        return new TransactionGetMultiReplicasFromPreferredServerGroupResult(results);
    }
}

