/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.util.BlockingStreamingHelper;
import com.couchbase.client.core.util.CbThrowables;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public interface CoreQueryOps {
    default public CoreQueryResult queryBlocking(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target, @Nullable Function<Throwable, RuntimeException> errorConverter) {
        return this.queryAsync(statement, options, queryContext, target, errorConverter).toBlocking();
    }

    default public CoreQueryMetaData queryBlockingStreaming(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target, @Nullable Function<Throwable, RuntimeException> errorConverter, Consumer<QueryChunkRow> callback) {
        try {
            CoreReactiveQueryResult response = (CoreReactiveQueryResult)this.queryReactive(statement, options, queryContext, target, errorConverter).blockOptional().orElseThrow(NoSuchElementException::new);
            BlockingStreamingHelper.forEachBlocking(response.rows(), 16, callback);
            return (CoreQueryMetaData)response.metaData().block();
        }
        catch (Exception e) {
            CbThrowables.findCause(e, InterruptedException.class).ifPresent(it -> {
                throw BlockingStreamingHelper.propagateAsCancellation(it);
            });
            throw e;
        }
    }

    public CoreAsyncResponse<CoreQueryResult> queryAsync(String var1, CoreQueryOptions var2, @Nullable CoreQueryContext var3, @Nullable NodeIdentifier var4, @Nullable Function<Throwable, RuntimeException> var5);

    public Mono<CoreReactiveQueryResult> queryReactive(String var1, CoreQueryOptions var2, @Nullable CoreQueryContext var3, @Nullable NodeIdentifier var4, @Nullable Function<Throwable, RuntimeException> var5);
}

