/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.queries.CoreGeoPoint;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.json.Mapper;

@Stability.Internal
public class CoreGeoCoordinates
implements CoreGeoPoint {
    private final double lat;
    private final double lon;

    private CoreGeoCoordinates(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    @Override
    public JsonNode toJson() {
        ArrayNode array = Mapper.createArrayNode();
        array.add(this.lon);
        array.add(this.lat);
        return array;
    }

    public String toString() {
        return "CoreGeoCoordinates{lat=" + this.lat + ", lon=" + this.lon + '}';
    }

    public static Lat lat(double lat) {
        return new Lat(lat);
    }

    public static Lon lon(double lon) {
        return new Lon(lon);
    }

    public static final class Lat {
        private final double lat;

        private Lat(double lat) {
            this.lat = lat;
        }

        public CoreGeoCoordinates lon(double lon) {
            return new CoreGeoCoordinates(this.lat, lon);
        }
    }

    public static final class Lon {
        private final double lon;

        private Lon(double lon) {
            this.lon = lon;
        }

        public CoreGeoCoordinates lat(double lat) {
            return new CoreGeoCoordinates(lat, this.lon);
        }
    }
}

