/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.Query;
import com.couchbase.client.protostellar.search.v1.QueryStringQuery;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreQueryStringQuery
extends CoreSearchQuery {
    private final String query;

    public CoreQueryStringQuery(String query, @Nullable Double boost) {
        super(boost);
        this.query = Validators.notNull(query, "Query");
    }

    @Override
    protected void injectParams(ObjectNode input) {
        input.put("query", this.query);
    }

    @Override
    public Query asProtostellar() {
        QueryStringQuery.Builder builder = QueryStringQuery.newBuilder().setQueryString(this.query);
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setQueryStringQuery(builder).build();
    }
}

