/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.KetamaRingNode;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.util.HostAndPort;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Deprecated
@JsonIgnoreProperties(ignoreUnknown=true)
public class NodeInfo
implements KetamaRingNode {
    private final String hostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;
    private final Map<String, AlternateAddress> alternateAddresses;
    private final com.couchbase.client.core.node.NodeIdentifier nodeIdentifier;
    private int configPort;
    @Nullable
    private final HostAndPort ketamaAuthority;

    @JsonCreator
    public NodeInfo(@JsonProperty(value="couchApiBase") String viewUri, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports, @JsonProperty(value="alternateAddresses") Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw InvalidArgumentException.fromMessage("NodeInfo hostname cannot be null");
        }
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
        try {
            this.hostname = this.trimPort(hostname);
        }
        catch (Exception e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        this.directServices = this.parseDirectServices(viewUri, ports);
        this.sslServices = new HashMap<ServiceType, Integer>();
        this.nodeIdentifier = new com.couchbase.client.core.node.NodeIdentifier(this.hostname, this.directServices.get((Object)ServiceType.MANAGER));
        this.ketamaAuthority = this.initKetamaAuthority();
    }

    @Nullable
    private HostAndPort initKetamaAuthority() {
        Integer port = this.directServices.get((Object)ServiceType.KV);
        return port == null ? null : new HostAndPort(this.hostname, port);
    }

    @Stability.Internal
    static com.couchbase.client.core.node.NodeIdentifier initNodeIdentifier(String host, Map<ServiceType, Integer> nonTlsPorts, Map<ServiceType, Integer> tlsPorts) {
        Integer managerPort = nonTlsPorts.get((Object)ServiceType.MANAGER);
        if (managerPort == null) {
            managerPort = tlsPorts.get((Object)ServiceType.MANAGER);
        }
        if (managerPort == null) {
            throw new IllegalStateException("A config must have at least a non-ssl or a ssl manager port defined!");
        }
        return new com.couchbase.client.core.node.NodeIdentifier(host, managerPort);
    }

    @Override
    @Nullable
    public HostAndPort ketamaAuthority() {
        return this.ketamaAuthority;
    }

    public NodeInfo(String hostname, Map<ServiceType, Integer> direct, Map<ServiceType, Integer> ssl, Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw InvalidArgumentException.fromMessage("NodeInfo hostname cannot be null");
        }
        this.hostname = hostname;
        this.directServices = direct;
        this.sslServices = ssl;
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
        this.nodeIdentifier = NodeInfo.initNodeIdentifier(hostname, this.directServices, this.sslServices);
        this.ketamaAuthority = this.initKetamaAuthority();
    }

    @Stability.Internal
    public NodeInfo(String hostname, Map<ServiceType, Integer> direct, Map<ServiceType, Integer> ssl, @Nullable HostAndPort ketamaAuthority, com.couchbase.client.core.node.NodeIdentifier nodeIdentifier) {
        this.hostname = Objects.requireNonNull(hostname);
        this.directServices = Objects.requireNonNull(direct);
        this.sslServices = Objects.requireNonNull(ssl);
        this.alternateAddresses = Collections.emptyMap();
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier);
        this.ketamaAuthority = ketamaAuthority;
    }

    public String hostname() {
        return this.hostname;
    }

    @Deprecated
    public com.couchbase.client.core.node.NodeIdentifier identifier() {
        return this.nodeIdentifier;
    }

    public NodeIdentifier id() {
        return this.nodeIdentifier.asTopologyNodeIdentifier();
    }

    public Map<ServiceType, Integer> services() {
        return this.directServices;
    }

    public Map<ServiceType, Integer> sslServices() {
        return this.sslServices;
    }

    public Map<String, AlternateAddress> alternateAddresses() {
        return this.alternateAddresses;
    }

    private Map<ServiceType, Integer> parseDirectServices(@Nullable String viewUri, @Nullable Map<String, Integer> input) {
        HashMap<ServiceType, Integer> services = new HashMap<ServiceType, Integer>();
        services.put(ServiceType.MANAGER, this.configPort);
        if (input != null) {
            for (Map.Entry<String, Integer> entry : input.entrySet()) {
                String type = entry.getKey();
                Integer port = entry.getValue();
                if (!type.equals("direct")) continue;
                services.put(ServiceType.KV, port);
            }
        }
        if (viewUri != null) {
            services.put(ServiceType.VIEWS, URI.create(viewUri).getPort());
        }
        return services;
    }

    private String trimPort(String hostname) {
        String[] parts = hostname.split(":");
        this.configPort = Integer.parseInt(parts[parts.length - 1]);
        if (parts.length > 2) {
            String assembledHost = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                assembledHost = assembledHost + parts[i];
                if (parts[i].endsWith("]")) break;
                assembledHost = assembledHost + ":";
            }
            if (assembledHost.startsWith("[") && assembledHost.endsWith("]")) {
                return assembledHost.substring(1, assembledHost.length() - 1);
            }
            if (assembledHost.endsWith(":")) {
                assembledHost = assembledHost.substring(0, assembledHost.length() - 1);
            }
            return assembledHost;
        }
        return parts[0];
    }

    public String toString() {
        return "NodeInfo{host=" + RedactableArgument.redactSystem(this.hostname) + ", ports=" + RedactableArgument.redactSystem(this.directServices) + ", securePorts=" + RedactableArgument.redactSystem(this.sslServices) + ", aa=" + RedactableArgument.redactSystem(this.alternateAddresses) + ", configPort=" + RedactableArgument.redactSystem(this.configPort) + ", nodeIdentifier=" + RedactableArgument.redactSystem(this.nodeIdentifier) + ", ketamaAuthority=" + RedactableArgument.redactSystem(this.ketamaAuthority) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        return this.configPort == nodeInfo.configPort && Objects.equals(this.hostname, nodeInfo.hostname) && Objects.equals(this.directServices, nodeInfo.directServices) && Objects.equals(this.sslServices, nodeInfo.sslServices) && Objects.equals(this.alternateAddresses, nodeInfo.alternateAddresses) && Objects.equals(this.nodeIdentifier, nodeInfo.nodeIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.directServices, this.sslServices, this.alternateAddresses, this.nodeIdentifier, this.configPort);
    }
}

