/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.DeferredCloseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.io.netty.analytics.AnalyticsHandlerSwitcher;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

public class AnalyticsEndpoint
extends DeferredCloseEndpoint {
    public AnalyticsEndpoint(ServiceContext ctx, String hostname, int port) {
        super(hostname, port, ctx.environment().ioEnvironment().analyticsEventLoopGroup().get(), ctx, ctx.environment().ioConfig().analyticsCircuitBreakerConfig(), ServiceType.ANALYTICS, false);
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new AnalyticsPipelineInitializer(this.context());
    }

    public static class AnalyticsPipelineInitializer
    implements PipelineInitializer {
        private final EndpointContext endpointContext;

        AnalyticsPipelineInitializer(EndpointContext endpointContext) {
            this.endpointContext = endpointContext;
        }

        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(AnalyticsHandlerSwitcher.SWITCHER_IDENTIFIER, (ChannelHandler)new AnalyticsHandlerSwitcher(endpoint, this.endpointContext));
        }
    }
}

