/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.env.InvalidPropertyException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.StorageSize;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@Stability.Internal
public class BuilderPropertySetter {
    private final String childBuilderAccessorSuffix;
    private final Map<String, String> irregularChildBuilderAccessors;
    private final Function<String, String> pathComponentTransformer;
    private final TypeConverterRegistry typeRegistry = new TypeConverterRegistry();

    public BuilderPropertySetter() {
        this("Config", CbCollections.mapOf("ioEnvironment", "ioEnvironment"), name -> name);
    }

    public BuilderPropertySetter(String childBuilderAccessorSuffix, Map<String, String> irregularChildBuilderAccessors, Function<String, String> pathComponentTransformer) {
        this.typeRegistry.register((Type)((Object)String.class), "a string", Function.identity()).register((Type)((Object)Integer.class), "an int", Integer::parseInt).register(Integer.TYPE, "an int", Integer::parseInt).register((Type)((Object)Long.class), "a long", Long::parseLong).register(Long.TYPE, "a long", Long::parseLong).register((Type)((Object)Double.class), "a double", Double::parseDouble).register(Double.TYPE, "a double", Double::parseDouble).register((Type)((Object)Float.class), "a float", Float::parseFloat).register(Float.TYPE, "a float", Float::parseFloat).register((Type)((Object)Boolean.class), "a boolean (\"true\", \"false\", \"1\", or \"0\")", BuilderPropertySetter::parseBooleanStrict).register(Boolean.TYPE, "a boolean (\"true\", \"false\", \"1\", or \"0\")", BuilderPropertySetter::parseBooleanStrict).register((Type)((Object)Duration.class), "a duration qualified by a time unit (like \"2.5s\" or \"300ms\")", d -> BuilderPropertySetter.requireNonNegative(Golang.parseDuration(d))).register((Type)((Object)StorageSize.class), "a storage size qualified by a size unit (like \"256B\" for 256 bytes, \"64KiB\" for 64 kibibytes, etc.)", StorageSize::parse).register((Type)((Object)Path.class), "an open file from a path", x$0 -> Paths.get(x$0, new String[0])).register((Type)((Object)Iterable.class), new CollectionConverter(ArrayList.class)).register((Type)((Object)Collection.class), new CollectionConverter(ArrayList.class)).register((Type)((Object)List.class), new CollectionConverter(ArrayList.class)).register((Type)((Object)Set.class), new CollectionConverter(LinkedHashSet.class));
        this.childBuilderAccessorSuffix = Objects.requireNonNull(childBuilderAccessorSuffix);
        this.irregularChildBuilderAccessors = CbCollections.mapCopyOf(irregularChildBuilderAccessors);
        this.pathComponentTransformer = Objects.requireNonNull(pathComponentTransformer);
    }

    public void set(Object builder, Map<String, String> properties) {
        properties.forEach((key, value) -> this.set(builder, (String)key, (String)value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object builder, String propertyName, String propertyValue) {
        try {
            List propertyComponents = Arrays.stream(propertyName.split("\\.", -1)).map(this.pathComponentTransformer).collect(Collectors.toList());
            List pathToBuilder = propertyComponents.subList(0, propertyComponents.size() - 1);
            String setterName = (String)propertyComponents.get(propertyComponents.size() - 1);
            for (String pathComponent : pathToBuilder) {
                try {
                    String childBuilderAccessor = this.irregularChildBuilderAccessors.getOrDefault(pathComponent, pathComponent + this.childBuilderAccessorSuffix);
                    AtomicReference ref = new AtomicReference();
                    Object[] objectArray = new Object[1];
                    objectArray[0] = ref::set;
                    builder.getClass().getMethod(childBuilderAccessor, Consumer.class).invoke(builder, objectArray);
                    builder = ref.get();
                }
                catch (NoSuchMethodException e) {
                    throw InvalidArgumentException.fromMessage("Method not found: " + e.getMessage(), e);
                }
            }
            List candidates = Arrays.stream(builder.getClass().getMethods()).filter(m -> m.getName().equals(setterName)).filter(m -> m.getParameterCount() == 1).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                throw InvalidArgumentException.fromMessage("No one-arg setter for property \"" + propertyName + "\" in " + builder.getClass());
            }
            int remainingCandidates = candidates.size();
            ArrayList<Throwable> failedCandidates = new ArrayList<Throwable>();
            for (Method setter : candidates) {
                try {
                    Object convertedValue = this.typeRegistry.convert(propertyValue, setter.getGenericParameterTypes()[0]);
                    setter.invoke(builder, convertedValue);
                }
                catch (Throwable t) {
                    if (candidates.size() == 1) {
                        throw t;
                    }
                    failedCandidates.add(t);
                    if (--remainingCandidates != 0) continue;
                    InvalidArgumentException e = InvalidArgumentException.fromMessage("Found multiple one-arg setters for property \"" + propertyName + "\" in " + builder.getClass() + " but none accepted the value \"" + propertyValue + "\".");
                    failedCandidates.forEach(e::addSuppressed);
                    throw e;
                    return;
                }
            }
        }
        catch (InvocationTargetException e) {
            throw InvalidPropertyException.forProperty(propertyName, propertyValue, e.getCause());
        }
        catch (Exception e) {
            throw InvalidPropertyException.forProperty(propertyName, propertyValue, e);
        }
    }

    private static <E extends Enum> E convertEnum(Class<E> enumClass, String value) {
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            List enumValueNames = Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
            throw InvalidArgumentException.fromMessage("Expected one of " + enumValueNames + " but got \"" + value + "\"");
        }
    }

    private static Class getRawType(Type t) {
        return t instanceof Class ? (Class)t : (Class)((ParameterizedType)t).getRawType();
    }

    private static Duration requireNonNegative(Duration d) {
        if (d.isNegative()) {
            throw InvalidArgumentException.fromMessage("Duration must be non-negative but got " + d);
        }
        return d;
    }

    private static boolean parseBooleanStrict(String value) {
        switch (value) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
        }
        throw InvalidArgumentException.fromMessage("Expected 'true', 'false', '0', or '1' but got '" + value + "'");
    }

    private static TypeReference asTypeReference(final Type t) {
        Objects.requireNonNull(t);
        return new TypeReference<Void>(){

            @Override
            public Type getType() {
                return t;
            }
        };
    }

    private static Optional<Class> asEnumClass(Type t) {
        return t instanceof Class && ((Class)t).isEnum() ? Optional.of((Class)t) : Optional.empty();
    }

    private static Optional<Class> getArrayComponentType(Type t) {
        return t instanceof Class && ((Class)t).isArray() ? Optional.of(((Class)t).getComponentType()) : Optional.empty();
    }

    private static List<String> splitList(String commaDelimitedList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : commaDelimitedList.split(",")) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }

    public static class TypeConverterRegistry {
        private final Map<Type, TypeConverter> converters = new HashMap<Type, TypeConverter>();

        public TypeConverterRegistry register(Type t, TypeConverter converter) {
            this.converters.put(Objects.requireNonNull(t), Objects.requireNonNull(converter));
            return this;
        }

        public TypeConverterRegistry register(Type t, final String expectation, final Function<String, ?> conversion) {
            Objects.requireNonNull(expectation);
            Objects.requireNonNull(conversion);
            return this.register(t, new TypeConverter(){

                @Override
                public String expectation(Type t, TypeConverterRegistry registry) {
                    return expectation;
                }

                @Override
                public Object convert(String s, TypeConverterRegistry registry, Type t) {
                    return conversion.apply(s);
                }
            });
        }

        public Object convert(String value, Type targetType) {
            TypeConverter converter = this.converters.get(BuilderPropertySetter.getRawType(targetType));
            if (converter != null) {
                try {
                    return converter.convert(value, this, targetType);
                }
                catch (Exception e) {
                    throw InvalidArgumentException.fromMessage("Expected " + converter.expectation(targetType, this) + " but got \"" + value + "\".", e);
                }
            }
            Optional arrayComponentType = BuilderPropertySetter.getArrayComponentType(targetType);
            if (arrayComponentType.isPresent()) {
                return this.convertArray((Class)arrayComponentType.get(), value);
            }
            Optional enumClass = BuilderPropertySetter.asEnumClass(targetType);
            if (enumClass.isPresent()) {
                return BuilderPropertySetter.convertEnum((Class)enumClass.get(), value);
            }
            if (targetType instanceof Class) {
                try {
                    Method factoryMethod = ((Class)targetType).getMethod("valueOf", String.class);
                    int modifiers = factoryMethod.getModifiers();
                    if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && Arrays.equals(factoryMethod.getParameterTypes(), new Class[]{String.class})) {
                        return factoryMethod.invoke(null, value);
                    }
                }
                catch (NoSuchMethodException factoryMethod) {
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return Mapper.reader().forType(BuilderPropertySetter.asTypeReference(targetType)).readValue(value);
            }
            catch (IOException e) {
                throw InvalidArgumentException.fromMessage("Expected a value Jackson can bind to " + targetType + " but got \"" + value + "\".", e);
            }
        }

        private Object convertArray(Class elementClass, String value) {
            try {
                List items = BuilderPropertySetter.splitList(value);
                Object array = Array.newInstance(elementClass, items.size());
                int i = 0;
                for (String item : items) {
                    Array.set(array, i++, this.convert(item, elementClass));
                }
                return array;
            }
            catch (IllegalArgumentException e) {
                throw InvalidArgumentException.fromMessage("Expected a comma-delimited list where each item is " + this.expectation(elementClass) + " but got \"" + value + "\".");
            }
        }

        public String expectation(Type type) {
            TypeConverter converter = this.converters.get(type);
            if (converter != null) {
                return converter.expectation(type, this);
            }
            Optional enumClass = BuilderPropertySetter.asEnumClass(type);
            if (enumClass.isPresent()) {
                return "one of " + Arrays.asList(((Class)enumClass.get()).getEnumConstants());
            }
            throw InvalidArgumentException.fromMessage("No converter for " + type);
        }
    }

    private static class CollectionConverter
    implements TypeConverter {
        private final Class<? extends Collection> collectionClass;

        public <T extends Collection> CollectionConverter(Class<T> collectionClass) {
            this.collectionClass = Objects.requireNonNull(collectionClass);
            this.newCollection();
        }

        @Override
        public String expectation(Type type, TypeConverterRegistry registry) {
            Type itemType = ((ParameterizedType)type).getActualTypeArguments()[0];
            return "a comma-delimited list where each item is " + registry.expectation(itemType);
        }

        @Override
        public Object convert(String s, TypeConverterRegistry registry, Type t) {
            Type itemType = ((ParameterizedType)t).getActualTypeArguments()[0];
            Collection<Object> result = this.newCollection();
            for (String item : BuilderPropertySetter.splitList(s)) {
                result.add(registry.convert(item, itemType));
            }
            return result;
        }

        private Collection<Object> newCollection() {
            try {
                return this.collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static interface TypeConverter {
        public String expectation(Type var1, TypeConverterRegistry var2);

        public Object convert(String var1, TypeConverterRegistry var2, Type var3);

        default public TypeConverter simple(final String expectation, final Function<String, ?> conversion) {
            Objects.requireNonNull(expectation);
            Objects.requireNonNull(conversion);
            return new TypeConverter(){

                @Override
                public String expectation(Type type, TypeConverterRegistry registry) {
                    return expectation;
                }

                @Override
                public Object convert(String s, TypeConverterRegistry registry, Type t) {
                    return conversion.apply(s);
                }
            };
        }
    }
}

