/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbCollections;
import java.util.List;
import java.util.Objects;

@Stability.Internal
public enum ClusterCapability {
    N1QL_ENHANCED_PREPARED_STATEMENTS("n1ql", "enhancedPreparedStatements"),
    N1QL_READ_FROM_REPLICA("n1ql", "readFromReplica"),
    SEARCH_VECTOR("search", "vectorSearch"),
    SEARCH_SCOPED("search", "scopedSearchIndex");

    private static final List<ClusterCapability> VALUES;
    private final String namespace;
    private final String wireName;

    private ClusterCapability(String namespace, String wireName) {
        this.namespace = Objects.requireNonNull(namespace);
        this.wireName = Objects.requireNonNull(wireName);
    }

    public static List<ClusterCapability> valueList() {
        return VALUES;
    }

    public String namespace() {
        return this.namespace;
    }

    public String wireName() {
        return this.wireName;
    }

    static {
        VALUES = CbCollections.listOf(ClusterCapability.values());
    }
}

