/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import io.fabric8.kubernetes.client.vertx.VertxHttpClientBuilder;
import io.fabric8.kubernetes.client.vertx.VertxHttpRequest;
import io.fabric8.kubernetes.client.vertx.VertxWebSocket;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class VertxHttpClient<F extends HttpClient.Factory>
extends StandardHttpClient<VertxHttpClient<F>, F, VertxHttpClientBuilder<F>> {
    private final Vertx vertx;
    private final HttpClient client;

    VertxHttpClient(VertxHttpClientBuilder<F> vertxHttpClientBuilder, HttpClient client, AtomicBoolean closed) {
        super(vertxHttpClientBuilder, closed);
        this.vertx = vertxHttpClientBuilder.vertx;
        this.client = client;
    }

    HttpClient getClient() {
        return this.client;
    }

    public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        StandardHttpRequest request;
        WebSocketConnectOptions options = new WebSocketConnectOptions();
        if (standardWebSocketBuilder.getSubprotocol() != null) {
            options.setSubProtocols(Collections.singletonList(standardWebSocketBuilder.getSubprotocol()));
        }
        if ((request = standardWebSocketBuilder.asHttpRequest()).getTimeout() != null) {
            options.setTimeout(request.getTimeout().toMillis());
        }
        request.headers().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> options.addHeader((String)e.getKey(), v)));
        options.setAbsoluteURI(io.fabric8.kubernetes.client.http.WebSocket.toWebSocketUri((URI)request.uri()).toString());
        CompletableFuture<WebSocketResponse> response = new CompletableFuture<WebSocketResponse>();
        this.client.webSocket(options).onSuccess(ws -> {
            VertxWebSocket ret = new VertxWebSocket((WebSocket)ws, listener);
            ret.init();
            response.complete(new WebSocketResponse(new WebSocketUpgradeResponse((HttpRequest)request), (io.fabric8.kubernetes.client.http.WebSocket)ret));
        }).onFailure(t -> {
            if (t instanceof UpgradeRejectedException) {
                UpgradeRejectedException handshake = (UpgradeRejectedException)t;
                WebSocketUpgradeResponse upgradeResponse = new WebSocketUpgradeResponse((HttpRequest)request, handshake.getStatus(), VertxHttpRequest.toHeadersMap(handshake.getHeaders()));
                response.complete(new WebSocketResponse(upgradeResponse, (Throwable)handshake));
            }
            response.completeExceptionally((Throwable)t);
        });
        return response;
    }

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        RequestOptions options = new RequestOptions();
        request.headers().forEach((k, l) -> l.forEach(v -> options.addHeader(k, v)));
        options.setAbsoluteURI(request.uri().toString());
        options.setMethod(HttpMethod.valueOf((String)request.method()));
        if (request.getTimeout() != null) {
            options.setTimeout(request.getTimeout().toMillis());
        }
        Optional.ofNullable(request.getContentType()).ifPresent(s -> options.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)s));
        if (request.isExpectContinue()) {
            options.putHeader(HttpHeaders.EXPECT, HttpHeaders.CONTINUE);
        }
        return new VertxHttpRequest(this.vertx, options, request).consumeBytes(this.client, consumer);
    }

    public void doClose() {
        this.client.close();
    }
}

