/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;

class ObserveSeqnoResponse {
    private final boolean didFailover;
    private final int vbid;
    private final long vbuuid;
    private final long persistSeqno;
    private final long currentSeqno;
    private final long oldVbuuid;
    private final long lastSeqno;

    ObserveSeqnoResponse(ByteBuf response) {
        ByteBuf content = MessageUtil.getContent(response);
        this.didFailover = content.readBoolean();
        this.vbid = content.readShort();
        this.vbuuid = content.readLong();
        this.persistSeqno = content.readLong();
        this.currentSeqno = content.readLong();
        this.oldVbuuid = this.didFailover ? content.readLong() : 0L;
        this.lastSeqno = this.didFailover ? content.readLong() : 0L;
    }

    public boolean didFailover() {
        return this.didFailover;
    }

    public int vbid() {
        return this.vbid;
    }

    public long vbuuid() {
        return this.vbuuid;
    }

    public long persistSeqno() {
        return this.persistSeqno;
    }

    public long currentSeqno() {
        return this.currentSeqno;
    }

    public long oldVbuuid() {
        return this.oldVbuuid;
    }

    public long lastSeqno() {
        return this.lastSeqno;
    }

    public String toString() {
        return "ObserveSeqnoResponse{didFailover=" + this.didFailover + ", vbid=" + this.vbid + ", vbuuid=" + this.vbuuid + ", persistSeqno=" + this.persistSeqno + ", currentSeqno=" + this.currentSeqno + ", oldVbuuid=" + this.oldVbuuid + ", lastSeqno=" + this.lastSeqno + '}';
    }
}

