/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.state;

import com.couchbase.client.dcp.core.state.Stateful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractStateMachine<S extends Enum>
implements Stateful<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Stateful.class);
    private volatile S currentState;

    protected AbstractStateMachine(S initialState) {
        this.currentState = initialState;
    }

    @Override
    public final S state() {
        return this.currentState;
    }

    @Override
    public final boolean isState(S state) {
        return this.currentState == state;
    }

    protected void transitionState(S newState) {
        if (newState != this.currentState) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("State (" + this.getClass().getSimpleName() + ") " + this.currentState + " -> " + newState);
            }
            this.currentState = newState;
        }
    }
}

