/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.utils;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public class UnsignedLEB128 {
    private UnsignedLEB128() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static long read(ByteBuf buf) {
        int readerMark = buf.readerIndex();
        try {
            return UnsignedLEB128.read(() -> ((ByteBuf)buf).readByte());
        }
        catch (Exception e) {
            buf.readerIndex(readerMark);
            throw e;
        }
    }

    public static void skip(ByteBuf buf) {
        int readerMark = buf.readerIndex();
        try {
            while ((buf.readByte() & 0x80) != 0) {
            }
        }
        catch (Exception e) {
            buf.readerIndex(readerMark);
            throw e;
        }
    }

    public static void write(ByteBuf buf, long value) {
        UnsignedLEB128.write(value, arg_0 -> ((ByteBuf)buf).writeByte(arg_0));
    }

    public static byte[] encode(long value) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        UnsignedLEB128.write(value, result::write);
        return result.toByteArray();
    }

    public static long decode(byte[] bytes) {
        return UnsignedLEB128.read(Unpooled.wrappedBuffer((byte[])bytes));
    }

    private static long read(IntSupplier byteSource) {
        long result = 0L;
        int i = 0;
        while (true) {
            boolean done;
            int b = byteSource.getAsInt();
            long low7Bits = b & 0x7F;
            boolean bl = done = (b & 0x80) == 0;
            if (i == 9 && (b & 0xFE) != 0) {
                throw new ArithmeticException("Value is larger than 64-bits");
            }
            result |= low7Bits << 7 * i;
            if (done) {
                return result;
            }
            ++i;
        }
    }

    private static void write(long value, IntConsumer byteSink) {
        while (true) {
            int b = (int)(value & 0x7FL);
            if ((value >>>= 7) == 0L) {
                byteSink.accept(b);
                return;
            }
            byteSink.accept(b | 0x80);
        }
    }
}

