/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel.internal;

import com.couchbase.client.dcp.highlevel.FlowControlMode;
import com.couchbase.client.dcp.highlevel.internal.BlockingQueueConsumerOps;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.highlevel.internal.FlowControllable;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class DatabaseChangeConsumerOps
implements BlockingQueueConsumerOps<DatabaseChangeEvent> {
    private final BlockingQueue<DatabaseChangeEvent> queue;
    private final boolean ackOnConsume;

    public DatabaseChangeConsumerOps(BlockingQueue<DatabaseChangeEvent> queue, FlowControlMode flowControlMode) {
        this.queue = Objects.requireNonNull(queue);
        this.ackOnConsume = Objects.requireNonNull(flowControlMode) == FlowControlMode.AUTOMATIC;
    }

    @Override
    public DatabaseChangeEvent take() throws InterruptedException {
        return this.maybeAck(this.queue.take());
    }

    @Override
    public DatabaseChangeEvent poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.maybeAck(this.queue.poll(timeout, unit));
    }

    private DatabaseChangeEvent maybeAck(DatabaseChangeEvent change) {
        if (this.ackOnConsume && change instanceof FlowControllable) {
            ((FlowControllable)((Object)change)).flowControlAck();
        }
        return change;
    }
}

