/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.apidoc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.therapi.apidoc.ApiExampleModelDoc;
import com.github.therapi.apidoc.ApiMethodDoc;
import com.github.therapi.apidoc.ApiModelDoc;
import com.github.therapi.apidoc.ApiNamespaceDoc;
import com.github.therapi.apidoc.ApiParamDoc;
import com.github.therapi.apidoc.JsonSchemaProvider;
import com.github.therapi.core.MethodDefinition;
import com.github.therapi.core.MethodRegistry;
import com.github.therapi.core.ParameterDefinition;
import com.github.therapi.core.internal.LangHelper;
import com.github.therapi.core.internal.TypesHelper;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentFormatter;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import com.google.common.collect.TreeMultimap;
import com.google.common.html.HtmlEscapers;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class ApiDocProvider {
    private final CommentFormatter commentFormatter = new CommentFormatter();
    private final JsonSchemaProvider schemaProvider = new JsonSchemaProvider();

    public List<ApiNamespaceDoc> getDocumentation(MethodRegistry registry) throws IOException {
        ObjectWriter prettyWriter = registry.getObjectMapper().writerWithDefaultPrettyPrinter();
        ArrayList<ApiNamespaceDoc> namespaces = new ArrayList<ApiNamespaceDoc>();
        TreeMultimap methodDefinitionsByNamespace = TreeMultimap.create(Comparator.naturalOrder(), (Comparator)new Comparator<MethodDefinition>(){

            @Override
            public int compare(MethodDefinition o1, MethodDefinition o2) {
                return o1.getUnqualifiedName().compareTo(o2.getUnqualifiedName());
            }
        });
        for (MethodDefinition mdef : registry.getMethods()) {
            methodDefinitionsByNamespace.put((Object)mdef.getNamespace().orElse(""), (Object)mdef);
        }
        for (String namespaceName : methodDefinitionsByNamespace.keySet()) {
            ApiNamespaceDoc nsDoc = new ApiNamespaceDoc();
            nsDoc.setName(namespaceName);
            ArrayList<ApiMethodDoc> methods = new ArrayList<ApiMethodDoc>();
            for (MethodDefinition mdef : methodDefinitionsByNamespace.get((Object)namespaceName)) {
                ApiMethodDoc mdoc = new ApiMethodDoc();
                mdoc.setName(mdef.getUnqualifiedName());
                mdoc.setReturnType(this.toJsonType(mdef.getReturnTypeRef()));
                mdoc.setRequestSchema(this.schemaProvider.getSchema(registry.getObjectMapper(), mdef));
                MethodJavadoc methodJavadoc = RuntimeJavadoc.getJavadoc((Method)mdef.getMethod());
                Map<String, ParamJavadoc> javadocsByParamName = LangHelper.index(methodJavadoc.getParams(), ParamJavadoc::getName);
                mdoc.setDescription(this.render(methodJavadoc.getComment()));
                mdoc.setReturns(this.render(methodJavadoc.getReturns()));
                ArrayList<ApiParamDoc> paramDocs = new ArrayList<ApiParamDoc>();
                for (ParameterDefinition pdef : mdef.getParameters()) {
                    ParamJavadoc paramJavadoc;
                    ApiParamDoc pdoc = new ApiParamDoc();
                    pdoc.setName(pdef.getName());
                    pdoc.setType(this.toJsonType(pdef.getType()));
                    Optional<Supplier<?>> defaultSupplier = pdef.getDefaultValueSupplier();
                    if (defaultSupplier.isPresent()) {
                        pdoc.setDefaultValue(prettyWriter.writeValueAsString(defaultSupplier.get().get()));
                    }
                    if ((paramJavadoc = javadocsByParamName.get(pdef.getName())) != null) {
                        pdoc.setDescription(this.render(paramJavadoc.getComment()));
                    }
                    paramDocs.add(pdoc);
                }
                mdoc.setParams(paramDocs);
                methods.add(mdoc);
            }
            nsDoc.setMethods(methods);
            namespaces.add(nsDoc);
        }
        return namespaces;
    }

    protected String toJsonType(TypeReference typeRef) {
        return TypesHelper.toJsonType(typeRef.getType());
    }

    protected String render(Comment comment) {
        return this.commentFormatter.format(comment);
    }

    public static String activateModelLinks(String typeName) {
        String result = HtmlEscapers.htmlEscaper().escape(typeName);
        for (String className : TypesHelper.getClassNames(typeName)) {
            String link = "<a href=\"modeldoc/" + className + "\">" + TypesHelper.getSimpleName(className) + "</a>";
            result = result.replace(className, link);
        }
        return result;
    }

    public Optional<ApiModelDoc> getModelDocumentation(MethodRegistry registry, String modelClassName) throws IOException {
        Class modelClass = TypesHelper.findClass(modelClassName).orElse(null);
        if (modelClass == null) {
            return Optional.empty();
        }
        ClassJavadoc classDoc = RuntimeJavadoc.getJavadoc((String)modelClassName);
        String commentHtml = this.render(classDoc.getComment());
        String schemaHtml = new JsonSchemaProvider().getSchemaForHtml(registry.getObjectMapper(), modelClass, JsonSchemaProvider.classNameToHyperlink()).orElse(null);
        List<ApiExampleModelDoc> examples = this.getExamples(registry, modelClass);
        return Optional.of(new ApiModelDoc(modelClass.getSimpleName(), modelClass.getName(), commentHtml, schemaHtml, examples));
    }

    public List<ApiExampleModelDoc> getExamples(MethodRegistry registry, Class modelClass) {
        ArrayList<ApiExampleModelDoc> results = new ArrayList<ApiExampleModelDoc>();
        for (Method factoryMethod : registry.getExampleFactoryMethods(modelClass)) {
            try {
                Object example = factoryMethod.invoke(null, new Object[0]);
                MethodJavadoc methodDoc = RuntimeJavadoc.getJavadoc((Method)factoryMethod);
                String commentHtml = this.render(methodDoc.getComment());
                String exampleJson = registry.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(example);
                results.add(new ApiExampleModelDoc(commentHtml, exampleJson));
            }
            catch (JsonProcessingException | IllegalAccessException | InvocationTargetException e) {
                throw LangHelper.propagate(e);
            }
        }
        return results;
    }
}

