/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.apidoc;

import com.github.therapi.apidoc.ApiDocProvider;
import com.github.therapi.apidoc.ApiMethodDoc;
import com.github.therapi.apidoc.ApiNamespaceDoc;
import com.github.therapi.apidoc.qndhtml.Attributes;
import com.github.therapi.apidoc.qndhtml.Tag;
import com.github.therapi.core.internal.LangHelper;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class ApiDocWriter {
    private static final String RESOURCE_PREFIX = "../therapi/";

    protected static String getResourcePrefix() {
        return RESOURCE_PREFIX;
    }

    public void writeTo(List<ApiNamespaceDoc> apiNamespaceDocs, Appendable out) throws IOException {
        Tag.html(Attributes.attrs("lang", "en"), this.apiDocHead(), Tag.body(Tag.div(Attributes.clazz("container"), Tag.div(Attributes.id("sidebar"), this.sidebarMenu(apiNamespaceDocs)), Tag.div(Attributes.id("header"), new Tag[0]), this.apiDocContent(apiNamespaceDocs)))).writeTo(out);
    }

    protected Tag apiDocHead() {
        return Tag.head(Tag.meta(Attributes.attrs("charset", "UTF-8")), Tag.meta(Attributes.attrs("http-equiv", "X-UA-Compatible").attr("content", "IE=edge")), Tag.meta(Attributes.attrs("http-equiv", "X-UA-Compatible").attr("content", "IE=edge")), Tag.meta(Attributes.attrs("name", "viewport").attr("content", "width=device-width, initial-scale=1")), Tag.styleSheetLink(ApiDocWriter.getResourcePrefix() + "cssmenu/styles.css"), Tag.scriptLink("https://code.jquery.com/jquery-1.11.3.min.js"), Tag.scriptLink(ApiDocWriter.getResourcePrefix() + "cssmenu/script.js"), Tag.styleSheetLink(ApiDocWriter.getResourcePrefix() + "json-forms/1.5.3/css/brutusin-json-forms.min.css"), Tag.scriptLink(ApiDocWriter.getResourcePrefix() + "json-forms/1.5.3/js/brutusin-json-forms.js"), Tag.styleSheetLink(ApiDocWriter.getResourcePrefix() + "highlight/styles/github-gist.css"), Tag.scriptLink(ApiDocWriter.getResourcePrefix() + "highlight/highlight.pack.js"), Tag.scriptLink(ApiDocWriter.getResourcePrefix() + "datagraph/jquery-jsonrpc/0.1.1/jquery.jsonrpc.js"), Tag.scriptLink(ApiDocWriter.getResourcePrefix() + "jakearchibald/es6-promise-3.0.2/es6-promise.min.js"), Tag.inlineScript("$.jsonRPC.setup({\n    endPoint: '../jsonrpc',\n});"), Tag.styleSheetLink(ApiDocWriter.getResourcePrefix() + "apidoc.css"), Tag.title("API Documentation"));
    }

    protected Tag sidebarMenu(List<ApiNamespaceDoc> apiNamespaces) {
        return Tag.div(Attributes.id("cssmenu"), Tag.ul(Tag.transform(apiNamespaces, ns -> Tag.li(Attributes.clazz("has-sub"), Tag.a(Attributes.href("#"), Tag.span(Tag.text(ns.getName())), Tag.ul(Tag.transform(ns.getMethods(), method -> Tag.li(Tag.a(Attributes.href("#" + ns.getName() + "." + method.getName()), Tag.span(Tag.text(method.getName())))))))))));
    }

    protected Tag apiDocContent(List<ApiNamespaceDoc> apiNamespaces) {
        return Tag.div(Attributes.id("content"), this.apiDocContentHeader(), Tag.transform(apiNamespaces, ns -> Tag.div(Tag.a(Attributes.name(ns.getName()), new Tag[0]), Tag.transform(ns.getMethods(), method -> this.methodDocContent((ApiNamespaceDoc)ns, (ApiMethodDoc)method)))), this.apiDocContentFooter());
    }

    protected Tag apiDocContentHeader() {
        return Tag.seq(Tag.text("Auth Token: "), Tag.input(Attributes.id("authToken").attr("size", "64"), new Tag[0]), Tag.br(new Tag[0]));
    }

    protected Tag apiDocContentFooter() {
        return null;
    }

    protected Tag methodDocContent(ApiNamespaceDoc ns, ApiMethodDoc method) {
        String qualifiedMethodName = ns.getName() + "." + method.getName();
        return Tag.div(Tag.a(Attributes.name(qualifiedMethodName), new Tag[0]), Tag.h2(Tag.span(Tag.text(qualifiedMethodName))), Tag.div(Attributes.style("padding-left: 10px; padding-right: 10px;"), Tag.span(Tag.text(method.getDescription())), Tag.p(new Tag[0]), this.parametersTable(method), this.returnTypeTable(method), Tag.preEscapedText(this.loadTryItResource(ns, method))), Tag.br(new Tag[0]));
    }

    protected Tag parametersTable(ApiMethodDoc method) {
        return Tag.table(Attributes.clazz("params"), Tag.caption(Tag.text("Parameters")), Tag.tr(Tag.th(Tag.text("Name")), Tag.th(Tag.text("Type")), Tag.th(Tag.text("Description")), Tag.th(Tag.text("Default"))), Tag.transform(method.getParams(), param -> Tag.tr(Tag.td(Tag.text(param.getName())), Tag.td(Tag.preEscapedText(ApiDocProvider.activateModelLinks(param.getType()))), Tag.td(Tag.text(param.getDescription())), Tag.td(Tag.code(Tag.text(param.getDefaultValue()))))));
    }

    protected Tag returnTypeTable(ApiMethodDoc method) {
        return Tag.table(Attributes.clazz("params"), Tag.caption(Tag.text("Returns")), Tag.tr(Tag.th(Tag.text("Type")), Tag.th(Tag.text("Description"))), Tag.tr(Tag.td(Tag.preEscapedText(ApiDocProvider.activateModelLinks(method.getReturnType()))), Tag.td(Tag.text(method.getReturns()))));
    }

    protected String getJsonRpcRequestHeaders() {
        return "{'" + this.getAuthHeaderName() + "': $('#authToken').val() }";
    }

    protected String getAuthHeaderName() {
        return "X-Auth-Token";
    }

    protected String loadTryItResource(ApiNamespaceDoc ns, ApiMethodDoc method) {
        String string;
        block8: {
            HashMap<String, String> variables = new HashMap<String, String>();
            Arrays.asList("formContainerId", "tryItButtonId", "explorerId", "formVar").forEach(variableName -> variables.put((String)variableName, this.buildName(ns, method, (String)variableName)));
            variables.put("requestHeaders", this.getJsonRpcRequestHeaders());
            variables.put("methodNameJsEscaped", StringEscapeUtils.escapeEcmaScript((String)(ns.getName() + "." + method.getName())));
            variables.put("requestSchema", StringEscapeUtils.escapeEcmaScript((String)method.getRequestSchema()));
            variables.put("requestContainerId", this.buildName(ns, method, "request"));
            variables.put("responseContainerId", this.buildName(ns, method, "response"));
            InputStream is = ApiDocWriter.class.getResourceAsStream("apidoc-try-it.html");
            try {
                String template = CharStreams.toString((Readable)new InputStreamReader(is, StandardCharsets.UTF_8));
                Pattern variablePattern = Pattern.compile("\\$\\{(.+?)\\}");
                string = LangHelper.replace(template, variablePattern, matcher -> {
                    String variableName = matcher.group(1);
                    return Matcher.quoteReplacement((String)variables.get(variableName));
                });
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw LangHelper.propagate(e);
                }
            }
            is.close();
        }
        return string;
    }

    protected String buildName(ApiNamespaceDoc ns, ApiMethodDoc method, String type) {
        return (type + "." + ns.getName() + "." + method.getName()).replace(".", "_");
    }
}

