/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.apidoc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.github.therapi.core.MethodDefinition;
import com.github.therapi.core.ParameterDefinition;
import com.github.therapi.core.internal.LangHelper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class JsonSchemaProvider {
    private static final Pattern REF_PROPERTY_PATTERN = Pattern.compile("(&quot;\\$ref&quot;\\s*:\\s*?&quot;)(.+?)(&quot;)");

    public String getSchema(ObjectMapper objectMapper, MethodDefinition methodDef) {
        try {
            ObjectNode methodNode = objectMapper.createObjectNode();
            methodNode.put("type", "object");
            methodNode.put("id", "urn:jsonschema:com:github:therapi:method:" + methodDef.getQualifiedName("."));
            LinkedHashMap<String, JsonNode> properties = new LinkedHashMap<String, JsonNode>();
            methodNode.putPOJO("properties", properties);
            for (ParameterDefinition paramDef : methodDef.getParameters()) {
                properties.put(paramDef.getName(), this.getParamSchema(objectMapper, paramDef));
            }
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)methodNode);
        }
        catch (JsonProcessingException e) {
            throw LangHelper.propagate(e);
        }
    }

    public Optional<String> getSchemaForHtml(ObjectMapper objectMapper, Class modelClass, Function<String, String> classNameToHyperlink) throws IOException {
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        visitor.setVisitorContext((VisitorContext)new VisitorContextWithoutSchemaInlining(){

            public String javaTypeToUrn(JavaType jt) {
                return jt.toCanonical();
            }
        });
        objectMapper.acceptJsonFormatVisitor(objectMapper.constructType((Type)modelClass), (JsonFormatVisitorWrapper)visitor);
        JsonSchema jsonSchema = visitor.finalSchema();
        JsonNode schemaNode = (JsonNode)objectMapper.convertValue((Object)jsonSchema, JsonNode.class);
        if (schemaNode.equals((Object)objectMapper.readTree("{\"type\":\"any\"}"))) {
            return Optional.empty();
        }
        String result = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schemaNode);
        result = StringEscapeUtils.escapeHtml3((String)result);
        result = this.activateRefLinks(result, classNameToHyperlink);
        return Optional.of(result);
    }

    protected String activateRefLinks(String result, Function<String, String> classNameToHyperlink) {
        return LangHelper.replace(result, REF_PROPERTY_PATTERN, m -> Matcher.quoteReplacement(m.group(1) + (String)classNameToHyperlink.apply(m.group(2))) + m.group(3));
    }

    public static Function<String, String> classNameToHyperlink() {
        return className -> "<a href=\"" + className + "\">" + StringEscapeUtils.escapeHtml3((String)className) + "</a>";
    }

    private JsonNode getParamSchema(ObjectMapper objectMapper, ParameterDefinition paramDef) throws JsonMappingException {
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        objectMapper.acceptJsonFormatVisitor(objectMapper.constructType(paramDef.getType().getType()), (JsonFormatVisitorWrapper)visitor);
        JsonSchema jsonSchema = visitor.finalSchema();
        jsonSchema.setRequired(Boolean.valueOf(!paramDef.getDefaultValueSupplier().isPresent()));
        return (JsonNode)objectMapper.convertValue((Object)jsonSchema, JsonNode.class);
    }

    public static class VisitorContextWithoutSchemaInlining
    extends VisitorContext {
        public String addSeenSchemaUri(JavaType aSeenSchema) {
            return this.getSeenSchemaUri(aSeenSchema);
        }

        public String getSeenSchemaUri(JavaType aSeenSchema) {
            return this.isModel(aSeenSchema) ? this.javaTypeToUrn(aSeenSchema) : null;
        }

        protected boolean isModel(JavaType type) {
            return type.getRawClass() != String.class && !VisitorContextWithoutSchemaInlining.isBoxedPrimitive(type) && !type.isPrimitive() && !type.isMapLikeType() && !type.isCollectionLikeType();
        }

        protected static boolean isBoxedPrimitive(JavaType type) {
            return type.getRawClass() == Boolean.class || type.getRawClass() == Byte.class || type.getRawClass() == Long.class || type.getRawClass() == Integer.class || type.getRawClass() == Short.class || type.getRawClass() == Float.class || type.getRawClass() == Double.class;
        }
    }
}

