/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.apidoc;

import com.github.therapi.apidoc.ApiExampleModelDoc;
import com.github.therapi.apidoc.ApiModelDoc;
import com.github.therapi.apidoc.qndhtml.Tag;
import com.google.common.collect.ImmutableList;
import java.io.IOException;

public class ModelDocWriter {
    public void writeTo(ApiModelDoc modelDoc, Appendable out) throws IOException {
        Tag.html(Tag.body(this.getDescription(modelDoc), this.getSchema(modelDoc), this.getExamples(modelDoc))).writeTo(out);
    }

    protected Tag getSchema(ApiModelDoc modelDoc) {
        String schema = modelDoc.getSchemaHtml();
        return schema == null ? null : Tag.seq(Tag.h2(Tag.text("Schema")), Tag.pre(Tag.preEscapedText(schema)));
    }

    protected Tag getDescription(ApiModelDoc modelDoc) throws IOException {
        String commentHtml = modelDoc.getCommentHtml();
        if (commentHtml == null) {
            return null;
        }
        return Tag.div(Tag.h2(Tag.text("Description")), Tag.preEscapedText(modelDoc.getCommentHtml()));
    }

    protected Tag getExamples(ApiModelDoc modelDoc) throws IOException {
        ImmutableList<ApiExampleModelDoc> examples = modelDoc.getExamples();
        if (examples.isEmpty()) {
            return null;
        }
        return Tag.div(Tag.h2(Tag.text("Examples")), Tag.transform(examples, example -> Tag.seq(Tag.preEscapedText(example.getCommentHtml()), Tag.pre(Tag.text(example.getExampleJson())))));
    }
}

