/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.therapi.core.ParameterDefinition;
import com.github.therapi.core.internal.JacksonHelper;
import com.github.therapi.core.internal.TypesHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MethodDefinition {
    private final String shortName;
    private final Method method;
    private final Method invokeVia;
    private final Object owner;
    private final ImmutableList<ParameterDefinition> params;
    private final Optional<String> namespace;
    private final TypeReference returnTypeRef;
    private final boolean requestLoggable;
    private final boolean responseLoggable;
    private final ImmutableMap<String, Object> customAttributes;

    public MethodDefinition(@Nullable String namespace, @Nullable String shortName, Method method, Object owner, List<ParameterDefinition> params, boolean requestLoggable, boolean responseLoggable, Map<String, Object> customAttributes) {
        this.method = method;
        this.invokeVia = TypesHelper.findOnInterface(method).orElse(method);
        this.owner = owner;
        this.params = ImmutableList.copyOf(params);
        this.namespace = Optional.ofNullable(StringUtils.trimToNull((String)namespace));
        this.shortName = (String)ObjectUtils.defaultIfNull((Object)shortName, (Object)method.getName());
        this.requestLoggable = requestLoggable;
        this.responseLoggable = responseLoggable;
        this.returnTypeRef = JacksonHelper.getReturnTypeReference(method, owner.getClass());
        this.customAttributes = ImmutableMap.copyOf(customAttributes);
    }

    public String getUnqualifiedName() {
        return this.shortName;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method getMethodForInvocation() {
        return this.invokeVia;
    }

    public Object getOwner() {
        return this.owner;
    }

    public ImmutableList<ParameterDefinition> getParameters() {
        return this.params;
    }

    public String getQualifiedName(String namespaceSeparator) {
        return this.namespace.isPresent() ? this.namespace.get() + namespaceSeparator + this.shortName : this.shortName;
    }

    public TypeReference getReturnTypeRef() {
        return this.returnTypeRef;
    }

    public Optional<String> getNamespace() {
        return this.namespace;
    }

    public boolean isRequestLoggable() {
        return this.requestLoggable;
    }

    public boolean isResponseLoggable() {
        return this.responseLoggable;
    }

    public ImmutableMap<String, Object> getCustomAttributes() {
        return this.customAttributes;
    }

    public String toString() {
        return this.getQualifiedName(".");
    }
}

