/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.github.therapi.core.MethodDefinition;
import com.github.therapi.core.MethodIntrospector;
import com.github.therapi.core.MethodNotFoundException;
import com.github.therapi.core.MissingArgumentException;
import com.github.therapi.core.NullArgumentException;
import com.github.therapi.core.ParameterBindingException;
import com.github.therapi.core.ParameterDefinition;
import com.github.therapi.core.StandardMethodIntrospector;
import com.github.therapi.core.TooManyPositionalArguments;
import com.github.therapi.core.annotation.ExampleModel;
import com.github.therapi.core.interceptor.SimpleMethodInvocation;
import com.github.therapi.core.internal.JacksonHelper;
import com.github.therapi.core.internal.LangHelper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodRegistry {
    private static final Logger log = LoggerFactory.getLogger(MethodRegistry.class);
    private final HashMap<String, MethodDefinition> methodsByName = new HashMap();
    private MethodIntrospector scanner;
    private final ObjectMapper objectMapper;
    private String namespaceSeparator = ".";
    private final ArrayListMultimap<Class, Method> modelClassToExampleFactoryMethods = ArrayListMultimap.create();
    private final List<InterceptorRegistration> interceptorRegistrations = new ArrayList<InterceptorRegistration>();
    private final ConcurrentMap<MethodDefinition, ImmutableList<MethodInterceptor>> methodDefinitionToInterceptors = new ConcurrentHashMap<MethodDefinition, ImmutableList<MethodInterceptor>>();
    private boolean suggestMethods = true;

    public ImmutableList<Method> getExampleFactoryMethods(Class modelClass) {
        return ImmutableList.copyOf((Collection)this.modelClassToExampleFactoryMethods.get((Object)modelClass));
    }

    public boolean isSuggestMethods() {
        return this.suggestMethods;
    }

    public void setSuggestMethods(boolean suggestMethods) {
        this.suggestMethods = suggestMethods;
    }

    public MethodRegistry() {
        this(new ObjectMapper());
    }

    public MethodRegistry(ObjectMapper objectMapper) {
        this(objectMapper, new StandardMethodIntrospector(objectMapper));
    }

    public MethodRegistry(ObjectMapper objectMapper, MethodIntrospector methodIntrospector) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.scanner = methodIntrospector;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void intercept(Predicate<MethodDefinition> predicate, MethodInterceptor interceptor) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(interceptor);
        this.interceptorRegistrations.add(new InterceptorRegistration(predicate, interceptor));
    }

    protected ImmutableList<MethodInterceptor> getInterceptors(MethodDefinition methodDef) {
        return MethodRegistry.computeIfAbsent(this.methodDefinitionToInterceptors, methodDef, methodDefintion -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.interceptorRegistrations.stream().filter(registration -> ((InterceptorRegistration)registration).predicate.test(methodDefintion)).forEach(registration -> builder.add((Object)((InterceptorRegistration)registration).interceptor));
            return builder.build();
        });
    }

    protected MethodInvocation newMethodInvocation(MethodDefinition methodDef, Object[] args, List<MethodInterceptor> interceptors) {
        return new SimpleMethodInvocation(methodDef, args, interceptors);
    }

    private static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        Object result = map.get(key);
        return result != null ? result : map.computeIfAbsent((K)key, mappingFunction);
    }

    public List<String> scan(Object o) {
        this.scanForExampleModels(o);
        ArrayList<String> methodNames = new ArrayList<String>();
        for (MethodDefinition methodDef : this.scanner.findMethods(o)) {
            this.add(methodDef);
            methodNames.add(this.getName(methodDef));
        }
        return methodNames;
    }

    protected void scanForExampleModels(Object o) {
        List classesToScan = ClassUtils.getAllInterfaces(o.getClass());
        classesToScan.add(o.getClass());
        for (Class scanMe : classesToScan) {
            for (Method m : scanMe.getMethods()) {
                ExampleModel exampleModel = m.getAnnotation(ExampleModel.class);
                if (exampleModel == null) continue;
                if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) {
                    throw new IllegalArgumentException("@ExampleModel annotation may only be applied to public static method, not " + m);
                }
                Class<?> modelClass = m.getReturnType();
                this.modelClassToExampleFactoryMethods.put(modelClass, (Object)m);
            }
        }
    }

    private void add(MethodDefinition methodDef) {
        this.methodsByName.put(this.getName(methodDef), methodDef);
    }

    public List<String> suggestMethods(String methodName) {
        TreeMultimap suggestionsByDistance = TreeMultimap.create();
        for (String name : this.methodsByName.keySet()) {
            int distance = new LevenshteinDistance(Integer.valueOf(25)).apply((CharSequence)name, (CharSequence)methodName);
            if (distance == -1) continue;
            suggestionsByDistance.put((Object)distance, (Object)name);
        }
        return suggestionsByDistance.entries().stream().limit(5L).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public JsonNode invoke(String methodName, JsonNode args) throws MethodNotFoundException {
        if (!args.isArray() && !args.isObject()) {
            throw new IllegalArgumentException("arguments must be ARRAY or OBJECT but encountered " + args.getNodeType());
        }
        MethodDefinition method = this.methodsByName.get(methodName);
        if (method == null) {
            throw MethodNotFoundException.forMethod(methodName, this.suggestMethods ? this.suggestMethods(methodName) : null);
        }
        Object[] boundArgs = this.bindArgs(method, args);
        return this.invoke(method, boundArgs);
    }

    private JsonNode invoke(MethodDefinition method, Object[] args) {
        try {
            MethodInvocation invocation = this.newMethodInvocation(method, args, (List<MethodInterceptor>)this.getInterceptors(method));
            Object result = invocation.proceed();
            TokenBuffer buffer = new TokenBuffer((ObjectCodec)this.objectMapper, false);
            this.objectMapper.writerFor(method.getReturnTypeRef()).writeValue((JsonGenerator)buffer, result);
            return (JsonNode)this.objectMapper.readTree(buffer.asParser());
        }
        catch (Throwable e) {
            throw LangHelper.propagate(e);
        }
    }

    private Object[] bindArgs(MethodDefinition method, JsonNode args) {
        if (args.isArray()) {
            return this.bindPositionalArguments(method, (ArrayNode)args);
        }
        return this.bindNamedArguments(method, (ObjectNode)args);
    }

    private Object[] bindNamedArguments(MethodDefinition method, ObjectNode args) {
        Object[] boundArgs = new Object[method.getParameters().size()];
        ImmutableList<ParameterDefinition> params = method.getParameters();
        int consumedArgCount = 0;
        int i = 0;
        for (ParameterDefinition p : params) {
            JsonNode arg = args.get(p.getName());
            if (!args.has(p.getName())) {
                if (p.getDefaultValueSupplier().isPresent()) {
                    boundArgs[i++] = p.getDefaultValueSupplier().get().get();
                    continue;
                }
                throw new MissingArgumentException(p.getName());
            }
            if (JacksonHelper.isLikeNull(arg) && !p.isNullable()) {
                throw new NullArgumentException(p.getName());
            }
            try {
                boundArgs[i++] = this.objectMapper.convertValue((Object)arg, p.getType());
                ++consumedArgCount;
            }
            catch (Exception e) {
                throw new ParameterBindingException(p.getName(), this.buildParamBindingErrorMessage(p, arg, e));
            }
        }
        if (consumedArgCount != args.size()) {
            Set parameterNames = params.stream().map(ParameterDefinition::getName).collect(Collectors.toSet());
            ImmutableSet argumentNames = ImmutableSet.copyOf((Iterator)args.fieldNames());
            Sets.SetView extraArguments = Sets.difference((Set)argumentNames, parameterNames);
            if (!extraArguments.isEmpty()) {
                throw new ParameterBindingException(null, "unrecognized argument names: " + extraArguments);
            }
        }
        return boundArgs;
    }

    private String getName(MethodDefinition method) {
        return method.getQualifiedName(this.namespaceSeparator);
    }

    private Object[] bindPositionalArguments(MethodDefinition method, ArrayNode args) {
        Object[] boundArgs = new Object[method.getParameters().size()];
        ImmutableList<ParameterDefinition> params = method.getParameters();
        if (args.size() > params.size()) {
            throw new TooManyPositionalArguments(params.size(), args.size());
        }
        for (int i = 0; i < params.size(); ++i) {
            ParameterDefinition param = (ParameterDefinition)params.get(i);
            if (!args.has(i)) {
                if (param.getDefaultValueSupplier().isPresent()) {
                    boundArgs[i] = param.getDefaultValueSupplier().get().get();
                    continue;
                }
                throw new MissingArgumentException(param.getName());
            }
            JsonNode arg = args.get(i);
            if (JacksonHelper.isLikeNull(arg) && !param.isNullable()) {
                throw new NullArgumentException(param.getName());
            }
            try {
                boundArgs[i] = this.objectMapper.convertValue((Object)arg, param.getType());
                continue;
            }
            catch (Exception e) {
                throw new ParameterBindingException(param.getName(), this.buildParamBindingErrorMessage(param, arg, e));
            }
        }
        return boundArgs;
    }

    private String buildParamBindingErrorMessage(ParameterDefinition param, JsonNode arg, Exception e) {
        String jacksonErrorMessage = e.getMessage().replace("\n at [Source: N/A; line: -1, column: -1]", "");
        String typeName = param.getType().getType().toString();
        return "Can't bind parameter '" + param.getName() + "' of type " + typeName + " to " + arg.getNodeType() + " value " + arg.toString() + " : " + jacksonErrorMessage;
    }

    public Collection<MethodDefinition> getMethods() {
        return Collections.unmodifiableCollection(this.methodsByName.values());
    }

    public Optional<MethodDefinition> getMethod(String methodName) {
        return Optional.ofNullable(this.methodsByName.get(methodName));
    }

    private static class InterceptorRegistration {
        private final Predicate<MethodDefinition> predicate;
        private final MethodInterceptor interceptor;

        private InterceptorRegistration(Predicate<MethodDefinition> predicate, MethodInterceptor interceptor) {
            this.predicate = predicate;
            this.interceptor = interceptor;
        }
    }
}

