/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.core;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ParameterDefinition {
    private final String name;
    private final boolean nullable;
    private final Optional<Supplier<?>> defaultValueSupplier;
    private final TypeReference type;

    public ParameterDefinition(String name, boolean nullable, @Nullable Supplier<?> defaultValueSupplier, TypeReference type) {
        this.name = name;
        this.nullable = nullable;
        this.defaultValueSupplier = Optional.ofNullable(defaultValueSupplier);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Optional<Supplier<?>> getDefaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    public TypeReference getType() {
        return this.type;
    }

    public String toString() {
        return "ParameterDefinition{name='" + this.name + '\'' + ", nullable=" + this.nullable + ", defaultValue=" + (this.defaultValueSupplier.isPresent() ? this.defaultValueSupplier.get().get() : "N/A") + '}';
    }
}

