/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.core.InvalidAnnotationException;
import com.github.therapi.core.MethodDefinition;
import com.github.therapi.core.MethodIntrospector;
import com.github.therapi.core.ParameterIntrospector;
import com.github.therapi.core.ProxyIntrospector;
import com.github.therapi.core.SpringAopProxyIntrospector;
import com.github.therapi.core.StandardParameterIntrospector;
import com.github.therapi.core.annotation.DoNotLog;
import com.github.therapi.core.annotation.Remotable;
import com.github.therapi.core.internal.TypesHelper;
import com.github.therapi.jackson.enums.CaseFormatHelper;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardMethodIntrospector
implements MethodIntrospector {
    private static final Logger log = LoggerFactory.getLogger(StandardMethodIntrospector.class);
    private final ParameterIntrospector parameterIntrospector;
    private final ProxyIntrospector proxyIntrospector;

    public StandardMethodIntrospector(ObjectMapper mapper) {
        this(new StandardParameterIntrospector(mapper));
    }

    public StandardMethodIntrospector(ParameterIntrospector parameterIntrospector) {
        this.parameterIntrospector = Objects.requireNonNull(parameterIntrospector);
        this.proxyIntrospector = this.getProxyIntrospector();
    }

    protected ProxyIntrospector getProxyIntrospector() {
        boolean springAopIsPresent = TypesHelper.findClass("org.springframework.aop.framework.AopProxyUtils").isPresent();
        return springAopIsPresent ? new SpringAopProxyIntrospector() : Object::getClass;
    }

    @Override
    public String getNamespace(Class<?> serviceClass) {
        Remotable remotable = serviceClass.getAnnotation(Remotable.class);
        return remotable == null || remotable.value().equals("_!$DEFAULT$!_") ? this.getDefaultNamespace(serviceClass) : remotable.value();
    }

    protected String getDefaultNamespace(Class<?> serviceClass) {
        String className = serviceClass.getSimpleName();
        className = StringUtils.removeEnd((String)className, (String)"Impl");
        className = StringUtils.removeEnd((String)className, (String)"Service");
        className = StringUtils.removeEnd((String)className, (String)"Controller");
        className = CaseFormatHelper.toLowerCamel(className);
        return className;
    }

    @Override
    public Collection<MethodDefinition> findMethods(Object o) {
        List methodsFromInterfaces = ClassUtils.getAllInterfaces(o.getClass()).stream().filter(iface -> iface.isAnnotationPresent(Remotable.class)).flatMap(iface -> this.findMethodsOnInterface(o, (Class<?>)iface, this.getNamespace((Class<?>)iface))).collect(Collectors.toList());
        ArrayList<MethodDefinition> result = new ArrayList<MethodDefinition>(methodsFromInterfaces);
        Class<?> targetClass = this.proxyIntrospector.getProxyTargetClass(o);
        Remotable remotableClass = targetClass.getAnnotation(Remotable.class);
        if (remotableClass != null) {
            String namespace = this.getNamespace(targetClass);
            ArrayList classHierarchy = new ArrayList();
            classHierarchy.add(targetClass);
            classHierarchy.addAll(ClassUtils.getAllSuperclasses(targetClass));
            classHierarchy.remove(classHierarchy.size() - 1);
            Collections.reverse(classHierarchy);
            boolean objectIsJdkDynamicProxy = Proxy.isProxyClass(o.getClass());
            HashMap<String, MethodDefinition> methodNameToDef = new HashMap<String, MethodDefinition>();
            for (Class clazz : classHierarchy) {
                for (Method method : clazz.getDeclaredMethods()) {
                    Remotable methodAnnotation = method.getAnnotation(Remotable.class);
                    if (methodAnnotation == null) continue;
                    if (!TypesHelper.isPublic(method)) {
                        throw new InvalidAnnotationException("Annotation @" + Remotable.class.getName() + " may only be applied to public methods, not " + method);
                    }
                    if (objectIsJdkDynamicProxy && !TypesHelper.findOnInterface(method).isPresent()) {
                        List proxiedInterfaces = Arrays.stream(o.getClass().getInterfaces()).filter(i -> !i.getName().startsWith("org.springframework.")).collect(Collectors.toList());
                        throw new InvalidAnnotationException("Annotation @" + Remotable.class.getName() + " on method " + method + " cannot be honored because invocation would bypass the JDK dynamic proxy (created by Spring?) To fix this problem, create the proxy using CGLib or add the remotable method to one of the interfaces being proxied, namely: " + proxiedInterfaces);
                    }
                    String methodName = methodAnnotation.value().equals("_!$DEFAULT$!_") ? method.getName() : methodAnnotation.value();
                    MethodDefinition prevDef = methodNameToDef.put(methodName, new MethodDefinition(namespace, null, method, o, this.parameterIntrospector.findParameters(method, o), this.isRequestLoggable(method), this.isResponseLoggable(method), (Map<String, Object>)this.getCustomAttributes(method)));
                    if (prevDef == null) continue;
                    log.warn("Remotable method {} with name {} overrides remotable method from superclass (or overloaded method on same class).Previous method definition will be ignored.", (Object)method, (Object)methodName);
                }
            }
            result.addAll(methodNameToDef.values());
        }
        return result;
    }

    protected Stream<MethodDefinition> findMethodsOnInterface(Object owner, Class<?> iface, String namespace) {
        return Arrays.stream(iface.getMethods()).filter(method -> !Modifier.isStatic(method.getModifiers())).map(method -> new MethodDefinition(namespace, null, (Method)method, owner, this.parameterIntrospector.findParameters((Method)method, owner), this.isRequestLoggable((Method)method), this.isResponseLoggable((Method)method), (Map<String, Object>)this.getCustomAttributes((Method)method)));
    }

    protected ImmutableMap<String, Object> getCustomAttributes(Method method) {
        return ImmutableMap.of();
    }

    protected boolean isRequestLoggable(Method method) {
        DoNotLog doNotLog = method.getAnnotation(DoNotLog.class);
        return doNotLog == null || doNotLog.value() == DoNotLog.Scope.RESPONSE;
    }

    protected boolean isResponseLoggable(Method method) {
        DoNotLog doNotLog = method.getAnnotation(DoNotLog.class);
        return doNotLog == null || doNotLog.value() == DoNotLog.Scope.REQUEST;
    }
}

