/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.core.InvalidAnnotationException;
import com.github.therapi.core.ParameterDefinition;
import com.github.therapi.core.ParameterIntrospector;
import com.github.therapi.core.annotation.Default;
import com.github.therapi.core.internal.JacksonHelper;
import com.github.therapi.core.internal.TypesHelper;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class StandardParameterIntrospector
implements ParameterIntrospector {
    private final ObjectMapper objectMapper;

    public StandardParameterIntrospector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public List<ParameterDefinition> findParameters(Method method, Object owner) {
        ArrayList<ParameterDefinition> params = new ArrayList<ParameterDefinition>();
        for (Parameter p : method.getParameters()) {
            TypeReference<?> typeReference = JacksonHelper.getTypeReference(p, owner.getClass());
            boolean nullable = this.isNullable(p, method);
            Supplier<?> defaultValueSupplier = this.getDefaultValueSupplier(p, typeReference, nullable);
            params.add(new ParameterDefinition(this.getName(p), nullable, defaultValueSupplier, typeReference));
        }
        return params;
    }

    @Nullable
    protected Supplier<?> getDefaultValueSupplier(Parameter p, TypeReference typeReference, boolean nullable) {
        Default defaultAnnotation = p.getAnnotation(Default.class);
        if (defaultAnnotation == null) {
            return nullable ? () -> null : null;
        }
        if ("_!$NULL$!_".equals(defaultAnnotation.value())) {
            return TypesHelper.getDefaultValueSupplier(p.getType());
        }
        String defValue = defaultAnnotation.value();
        if (p.getType().isEnum() && !defValue.startsWith("\"") && !defValue.startsWith("'")) {
            defValue = "\"" + defValue + "\"";
        }
        String defaultValueStr = defValue;
        if (p.getType().equals(String.class)) {
            return () -> defaultValueStr;
        }
        Supplier<Object> result = () -> {
            try {
                return this.objectMapper.readValue(defaultValueStr, typeReference);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to deserialize default value for parameter '" + p.getName() + "' of " + p.getDeclaringExecutable(), e);
            }
        };
        result.get();
        return result;
    }

    protected String getName(Parameter p) {
        return p.getName();
    }

    protected boolean isNullable(Parameter p, Method method) {
        if (this.hasNullableAnnotation(p)) {
            if (p.getType().isPrimitive()) {
                throw new InvalidAnnotationException("Annotation @" + Nullable.class.getName() + " may not be applied to primitive " + p.getType() + " parameter '" + p.getName() + "' of method: " + method);
            }
            return true;
        }
        Default defaultAnnontation = p.getAnnotation(Default.class);
        return defaultAnnontation != null && "_!$NULL$!_".equals(defaultAnnontation.value());
    }

    private boolean hasNullableAnnotation(Parameter p) {
        for (Annotation a : p.getAnnotations()) {
            if (!a.annotationType().getSimpleName().equals("Nullable")) continue;
            return true;
        }
        return false;
    }
}

