/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.core.interceptor;

import com.github.therapi.core.MethodDefinition;
import com.github.therapi.core.interceptor.MethodDefinitionInvocation;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SimpleMethodInvocation
implements MethodDefinitionInvocation {
    private final MethodDefinition methodDefinition;
    private final Object[] arguments;
    private final ImmutableList<MethodInterceptor> interceptors;
    private int currentInterceptorIndex = -1;

    public SimpleMethodInvocation(MethodDefinition methodDefinition, Object[] args, List<MethodInterceptor> interceptors) {
        this.methodDefinition = Objects.requireNonNull(methodDefinition);
        this.arguments = Objects.requireNonNull(args);
        this.interceptors = ImmutableList.copyOf(interceptors);
    }

    @Override
    public MethodDefinition getMethodDefinition() {
        return this.methodDefinition;
    }

    public Method getMethod() {
        return this.methodDefinition.getMethodForInvocation();
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object proceed() throws Throwable {
        return this.currentInterceptorIndex == this.interceptors.size() - 1 ? this.invokeTargetMethod() : ((MethodInterceptor)this.interceptors.get(++this.currentInterceptorIndex)).invoke((MethodInvocation)this);
    }

    protected Object invokeTargetMethod() throws Throwable {
        Method method = this.getMethod();
        try {
            return method.invoke(this.methodDefinition.getOwner(), this.arguments);
        }
        catch (IllegalAccessException e) {
            method.setAccessible(true);
            return method.invoke(this.methodDefinition.getOwner(), this.arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object getThis() {
        return this.methodDefinition.getOwner();
    }

    public AccessibleObject getStaticPart() {
        return this.getMethod();
    }
}

