/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.core.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class TypesHelper {
    private static final Pattern QUALIFIED_CLASS_NAME = Pattern.compile("[^<>,\\s]+");

    public static List<String> getClassNames(String typeName) {
        ArrayList<String> classNames = new ArrayList<String>();
        Matcher m = QUALIFIED_CLASS_NAME.matcher(typeName);
        while (m.find()) {
            if (!m.group().contains(".")) continue;
            classNames.add(m.group());
        }
        return classNames;
    }

    public static String getSimpleName(String className) {
        if (className.contains("$")) {
            return StringUtils.substringAfterLast((String)className, (String)"$");
        }
        if (className.contains(".")) {
            return StringUtils.substringAfterLast((String)className, (String)".");
        }
        return className;
    }

    public static Supplier<?> getDefaultValueSupplier(Class<?> type) {
        if (type == Boolean.TYPE) {
            return () -> false;
        }
        if (type == Integer.TYPE) {
            return () -> 0;
        }
        if (type == Long.TYPE) {
            return () -> 0L;
        }
        if (type == Character.TYPE) {
            return () -> Character.valueOf('\u0000');
        }
        if (type == Short.TYPE) {
            return () -> (short)0;
        }
        if (type == Byte.TYPE) {
            return () -> (byte)0;
        }
        if (type == Double.TYPE) {
            return () -> 0.0;
        }
        if (type == Float.TYPE) {
            return () -> Float.valueOf(0.0f);
        }
        return () -> null;
    }

    public static String toJsonType(Type type) {
        String typeName = type.toString();
        typeName = StringUtils.removeStart((String)typeName, (String)"class ");
        if ((typeName = StringUtils.removeStart((String)typeName, (String)"interface ")).equals("int") || typeName.equals("long")) {
            return "integer";
        }
        if (typeName.equals("float") || typeName.equals("double")) {
            return "number";
        }
        typeName = typeName.replace("java.lang.Object", "any");
        typeName = typeName.replace("java.lang.String", "string");
        typeName = typeName.replace("java.lang.Integer", "integer");
        typeName = typeName.replace("java.lang.Long", "integer");
        typeName = typeName.replace("java.lang.Float", "number");
        typeName = typeName.replace("java.lang.Double", "number");
        typeName = typeName.replace("java.util.Set", "array");
        typeName = typeName.replace("java.util.List", "array");
        typeName = typeName.replace("java.util.Collection", "array");
        typeName = typeName.replace("java.util.Map", "map");
        typeName = typeName.replace("java.util.Optional", "optional");
        if ((typeName = typeName.replace("com.google.common.base.Optional", "optional")).startsWith("com.google.common.collect.Multimap")) {
            String params = StringUtils.substringBetween((String)typeName, (String)"<", (String)">");
            String keyType = StringUtils.substringBefore((String)params, (String)",").trim();
            String valueType = StringUtils.substringAfter((String)params, (String)",").trim();
            typeName = "map<" + keyType + ", array<" + valueType + ">>";
        }
        return typeName;
    }

    public static Optional<Class> findClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static Optional<Method> findOnInterface(Method m) {
        if (m.getDeclaringClass().isInterface()) {
            return Optional.of(m);
        }
        Class<?>[] parameterTypes = m.getParameterTypes();
        for (Class i : ClassUtils.getAllInterfaces(m.getDeclaringClass())) {
            try {
                return Optional.of(i.getDeclaredMethod(m.getName(), parameterTypes));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return Optional.empty();
    }

    public static boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }
}

