/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jackson.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CaseFormatHelper {
    public static String toLowerCamel(String name) {
        return CaseFormatHelper.toLowerCamel(name, Locale.ROOT);
    }

    public static String toLowerCamel(String name, Locale locale) {
        StringBuilder result = new StringBuilder();
        for (String word : CaseFormatHelper.splitWords(name)) {
            result.append(CaseFormatHelper.capitalize(word.toLowerCase(locale)));
        }
        result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        return result.toString();
    }

    private static String capitalize(String s) {
        char first = s.charAt(0);
        return Character.isTitleCase(first) ? s : Character.toTitleCase(first) + s.substring(1);
    }

    public static List<String> splitWords(String name) {
        name = name.replaceAll("_{2,}", "_");
        name = name.replaceAll("-{2,}", "-");
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentWord = new StringBuilder(name.length());
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char prev;
            char c = name.charAt(i);
            char next = i == len - 1 ? (char)'\u0000' : name.charAt(i + 1);
            char c2 = prev = i == 0 ? (char)'\u0000' : name.charAt(i - 1);
            if (!(c != '_' && c != '-' || Character.isDigit(next) && Character.isDigit(prev))) {
                if (currentWord.length() <= 0) continue;
                result.add(currentWord.toString());
                currentWord.setLength(0);
                continue;
            }
            if (Character.isUpperCase(c) && (!Character.isUpperCase(prev) || Character.isLowerCase(next)) && currentWord.length() > 0) {
                result.add(currentWord.toString());
                currentWord.setLength(0);
            }
            currentWord.append(c);
        }
        result.add(currentWord.toString());
        return result;
    }
}

