/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jackson.enums;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;

public abstract class EnumRenamingModule
extends SimpleModule {
    private boolean overrideExistingNames;

    public EnumRenamingModule() {
        super("therapi-enum-renaming");
    }

    public EnumRenamingModule overrideExistingNames() {
        this.overrideExistingNames = true;
        return this;
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.insertAnnotationIntrospector((AnnotationIntrospector)new EnumNamingAnnotationIntrospector());
    }

    protected abstract String getName(Enum<?> var1);

    private class EnumNamingAnnotationIntrospector
    extends NopAnnotationIntrospector {
        private EnumNamingAnnotationIntrospector() {
        }

        public String[] findEnumValues(Class<?> enumType, Enum<?>[] enumValues, String[] names) {
            for (int i = 0; i < enumValues.length; ++i) {
                if (names[i] != null && !EnumRenamingModule.this.overrideExistingNames) continue;
                names[i] = EnumRenamingModule.this.getName(enumValues[i]);
            }
            return names;
        }
    }
}

