/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc;

import com.fasterxml.jackson.core.JsonParseException;
import com.github.therapi.core.MethodNotFoundException;
import com.github.therapi.core.ParameterBindingException;
import com.github.therapi.jsonrpc.ExceptionTranslator;
import com.github.therapi.jsonrpc.InternalErrorException;
import com.github.therapi.jsonrpc.InvalidRequestException;
import com.github.therapi.jsonrpc.JsonRpcError;
import com.github.therapi.jsonrpc.ParseException;
import java.util.Collections;

public class DefaultExceptionTranslator
implements ExceptionTranslator {
    private boolean includeDetailsForStandardErrors = true;

    public void setIncludeDetailsForStandardErrors(boolean includeDetailsForStandardErrors) {
        this.includeDetailsForStandardErrors = includeDetailsForStandardErrors;
    }

    public DefaultExceptionTranslator excludeDetails() {
        this.setIncludeDetailsForStandardErrors(false);
        return this;
    }

    @Override
    public JsonRpcError translate(Throwable t) {
        if (t instanceof InvalidRequestException) {
            JsonRpcError e = new JsonRpcError(-32600, "Invalid request");
            if (this.includeDetailsForStandardErrors) {
                e.setData(Collections.singletonMap("detail", t.getMessage()));
            }
            return e;
        }
        if (t instanceof ParseException) {
            String detail = t.getCause() instanceof JsonParseException ? t.getCause().getMessage() : t.getMessage();
            JsonRpcError e = new JsonRpcError(-32700, "Parse error");
            if (this.includeDetailsForStandardErrors) {
                e.setData(Collections.singletonMap("detail", detail));
            }
            return e;
        }
        if (t instanceof MethodNotFoundException) {
            JsonRpcError e = new JsonRpcError(-32601, "Method '" + ((MethodNotFoundException)t).getMethod() + "' not found");
            if (this.includeDetailsForStandardErrors) {
                e.setData(Collections.singletonMap("suggestions", ((MethodNotFoundException)t).getSuggestions()));
            }
            return e;
        }
        if (t instanceof InternalErrorException) {
            JsonRpcError e = new JsonRpcError(-32603, "Internal error");
            if (this.includeDetailsForStandardErrors) {
                e.setData(Collections.singletonMap("detail", t.getMessage()));
            }
            return e;
        }
        if (t instanceof ParameterBindingException) {
            JsonRpcError e = new JsonRpcError(-32602, "Invalid params");
            if (this.includeDetailsForStandardErrors) {
                e.setData(Collections.singletonMap("detail", t.getMessage()));
            }
            return e;
        }
        return this.translateCustom(t);
    }

    protected JsonRpcError translateCustom(Throwable t) {
        return new JsonRpcError(-32603, "Internal error");
    }
}

