/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc;

import com.github.therapi.core.MethodDefinition;
import com.github.therapi.jsonrpc.JsonRpcLogger;
import org.slf4j.Logger;

public class DefaultJsonRpcLogger
implements JsonRpcLogger {
    protected LogLevel getRequestLogLevel() {
        return LogLevel.INFO;
    }

    protected LogLevel getResponseTimeLogLevel() {
        return LogLevel.INFO;
    }

    protected LogLevel getSuccessfulResponseBodyLogLevel() {
        return LogLevel.DEBUG;
    }

    protected LogLevel getErrorResponseBodyLogLevel() {
        return LogLevel.INFO;
    }

    protected LogLevel getExceptionLogLevel() {
        return LogLevel.WARN;
    }

    @Override
    public void logException(Throwable t) {
        this.getExceptionLogLevel().log(log, "Exception thrown during json-rpc invocation", t);
    }

    @Override
    public void logRequest(JsonRpcLogger.RequestInfo requestInfo) {
        MethodDefinition methodDef = requestInfo.getMethodDefinition().orElse(null);
        boolean loggable = methodDef != null && methodDef.isRequestLoggable();
        this.getRequestLogLevel().log(log, "Invoking '{}' {}", requestInfo.getMethodName(), loggable ? requestInfo.getArguments() : "(args not loggable)");
    }

    @Override
    public void logSuccessResponse(JsonRpcLogger.RequestInfo requestInfo, JsonRpcLogger.ResponseInfo responseInfo) {
        String methodName = requestInfo.getMethodName();
        MethodDefinition methodDef = requestInfo.getMethodDefinition().orElse(null);
        this.getResponseTimeLogLevel().log(log, "'{}' completed successfully in {}", methodName, responseInfo.getExecutionTimer());
        boolean loggable = methodDef != null && methodDef.isResponseLoggable();
        this.getSuccessfulResponseBodyLogLevel().log(log, "'{}' response: {}", methodName, loggable ? responseInfo.getResponse() : "(not loggable)");
    }

    @Override
    public void logErrorResponse(JsonRpcLogger.RequestInfo requestInfo, JsonRpcLogger.ResponseInfo responseInfo) {
        String methodName = requestInfo.getMethodName();
        this.getResponseTimeLogLevel().log(log, "'{}' completed with error in {}", methodName, responseInfo.getExecutionTimer());
        this.getErrorResponseBodyLogLevel().log(log, "'{}' error response: {}", methodName, responseInfo.getResponse());
    }

    protected static enum LogLevel {
        ERROR{

            @Override
            public void log(Logger logger, String message, Object ... args) {
                logger.error(message, args);
            }
        }
        ,
        WARN{

            @Override
            public void log(Logger logger, String message, Object ... args) {
                logger.warn(message, args);
            }
        }
        ,
        INFO{

            @Override
            public void log(Logger logger, String message, Object ... args) {
                logger.info(message, args);
            }
        }
        ,
        DEBUG{

            @Override
            public void log(Logger logger, String message, Object ... args) {
                logger.debug(message, args);
            }
        };


        public abstract void log(Logger var1, String var2, Object ... var3);
    }
}

