/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc;

import com.github.therapi.core.MethodRegistry;
import com.github.therapi.jsonrpc.DefaultExceptionTranslator;
import com.github.therapi.jsonrpc.DefaultJsonRpcLogger;
import com.github.therapi.jsonrpc.ExceptionTranslator;
import com.github.therapi.jsonrpc.JsonRpcDispatcher;
import com.github.therapi.jsonrpc.JsonRpcDispatcherImpl;
import com.github.therapi.jsonrpc.JsonRpcLogger;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class JsonRpcDispatcherBuilder {
    private final MethodRegistry registry;
    private ExceptionTranslator exceptionTranslator = new DefaultExceptionTranslator();
    private JsonRpcLogger logger = new DefaultJsonRpcLogger();
    private ExecutorService executorService = MoreExecutors.newDirectExecutorService();

    JsonRpcDispatcherBuilder(MethodRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    public JsonRpcDispatcherBuilder exceptionTranslator(ExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = Objects.requireNonNull(exceptionTranslator);
        return this;
    }

    public JsonRpcDispatcherBuilder batchExecutorService(ExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService);
        return this;
    }

    public JsonRpcDispatcherBuilder logger(JsonRpcLogger logger) {
        this.logger = Objects.requireNonNull(logger);
        return this;
    }

    public JsonRpcDispatcher build() {
        return new JsonRpcDispatcherImpl(this.registry, this.exceptionTranslator, this.executorService, this.logger);
    }
}

