/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.therapi.core.MethodDefinition;
import com.github.therapi.core.MethodRegistry;
import com.github.therapi.core.internal.JacksonHelper;
import com.github.therapi.jsonrpc.ExceptionTranslator;
import com.github.therapi.jsonrpc.InternalErrorException;
import com.github.therapi.jsonrpc.InvalidRequestException;
import com.github.therapi.jsonrpc.JsonRpcDispatcher;
import com.github.therapi.jsonrpc.JsonRpcError;
import com.github.therapi.jsonrpc.JsonRpcLogger;
import com.github.therapi.jsonrpc.ParseException;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcDispatcherImpl
implements JsonRpcDispatcher {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcDispatcherImpl.class);
    protected final MethodRegistry methodRegistry;
    protected final ExecutorService executorService;
    protected final ExceptionTranslator exceptionTranslator;
    protected final JsonRpcLogger jsonRpcLogger;

    JsonRpcDispatcherImpl(MethodRegistry registry, ExceptionTranslator translator, ExecutorService executorService, JsonRpcLogger jsonRpcLogger) {
        this.methodRegistry = Objects.requireNonNull(registry);
        this.executorService = Objects.requireNonNull(executorService);
        this.exceptionTranslator = Objects.requireNonNull(translator);
        this.jsonRpcLogger = Objects.requireNonNull(jsonRpcLogger);
    }

    protected ObjectMapper getObjectMapper() {
        return this.methodRegistry.getObjectMapper();
    }

    protected JsonNode parseNode(String json) {
        try {
            return this.getObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    protected JsonNode parseNode(InputStream json) {
        try {
            return this.getObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    protected ArrayNode newArray() {
        return this.getObjectMapper().createArrayNode();
    }

    @Override
    public Optional<JsonNode> invoke(InputStream jsonRpcRequest) {
        try {
            JsonNode requestNode = this.parseNode(jsonRpcRequest);
            return this.invoke(requestNode);
        }
        catch (Throwable t) {
            this.jsonRpcLogger.logException(t);
            JsonRpcError jsonRpcError = this.exceptionTranslator.translate(t);
            return Optional.of(this.buildErrorResponse(jsonRpcError, null));
        }
    }

    protected Optional<JsonNode> invoke(JsonNode requestNode) {
        try {
            if (requestNode.isArray()) {
                ArrayNode batchResult = this.invokeBatch((ArrayNode)requestNode);
                return batchResult.size() == 0 ? Optional.empty() : Optional.of(batchResult);
            }
            if (requestNode.isObject()) {
                ObjectNode soloResponse = this.invokeSolo(requestNode);
                if (JacksonHelper.isLikeNull(requestNode.get("id")) && this.isValidSoloRequest(requestNode)) {
                    log.debug("suppressing notification response because request had null 'id': {}", (Object)soloResponse);
                    return Optional.empty();
                }
                return Optional.of(soloResponse);
            }
            throw new InvalidRequestException("expected json-rpc request node to be ARRAY or OBJECT but found " + requestNode.getNodeType());
        }
        catch (Throwable t) {
            this.jsonRpcLogger.logException(t);
            JsonRpcError jsonRpcError = this.exceptionTranslator.translate(t);
            return Optional.of(this.buildErrorResponse(jsonRpcError, null));
        }
    }

    @Override
    public Optional<JsonNode> invoke(String jsonRpcRequest) {
        jsonRpcRequest = this.expandShorthand(jsonRpcRequest);
        try {
            JsonNode requestNode = this.parseNode(jsonRpcRequest);
            return this.invoke(requestNode);
        }
        catch (Throwable t) {
            this.jsonRpcLogger.logException(t);
            JsonRpcError jsonRpcError = this.exceptionTranslator.translate(t);
            return Optional.of(this.buildErrorResponse(jsonRpcError, null));
        }
    }

    @Override
    public MethodRegistry getMethodRegistry() {
        return this.methodRegistry;
    }

    protected String expandShorthand(String request) {
        String params;
        String method;
        if (request.startsWith("{") || request.startsWith("[")) {
            return request;
        }
        int paramStartIndex = StringUtils.indexOfAny((CharSequence)request, (char[])new char[]{'{', '['});
        if (paramStartIndex == -1) {
            method = request.trim();
            params = "{}";
        } else {
            method = request.substring(0, paramStartIndex).trim();
            params = request.substring(paramStartIndex);
        }
        return "{\"jsonrpc\":\"2.0\",\"id\":\"\",\"method\":\"" + method + "\",\"params\":" + params + "}";
    }

    protected boolean isValidSoloRequest(JsonNode soloRequest) {
        try {
            this.validateSoloRequest(soloRequest);
            return true;
        }
        catch (InvalidRequestException e) {
            return false;
        }
    }

    protected Request validateSoloRequest(JsonNode soloRequest) throws InvalidRequestException {
        JsonNode params;
        if (!soloRequest.isObject()) {
            throw new InvalidRequestException("expected request node to be OBJECT but found " + soloRequest.getNodeType());
        }
        JsonNode methodName = soloRequest.get("method");
        if (JacksonHelper.isLikeNull(methodName)) {
            throw new InvalidRequestException("missing non-null 'method' field");
        }
        if (!methodName.isTextual()) {
            throw new InvalidRequestException("expected 'method' to be a STRING but found " + methodName.getNodeType());
        }
        JsonNode idNode = soloRequest.get("id");
        if (!this.isValidId(idNode)) {
            throw new InvalidRequestException("expected 'id' to be NULL or STRING or NUMBER but found " + idNode.getNodeType());
        }
        JsonNode versionNode = soloRequest.get("jsonrpc");
        if (versionNode != null) {
            if (!versionNode.isTextual()) {
                throw new InvalidRequestException("expected 'jsonrpc' to be a STRING but found " + versionNode.getNodeType());
            }
            if (!versionNode.asText().equals("2.0")) {
                throw new InvalidRequestException("expected 'jsonrpc' to be '2.0' but found '" + versionNode.asText() + "'");
            }
        }
        if (JacksonHelper.isLikeNull(params = soloRequest.get("params"))) {
            params = this.getObjectMapper().createObjectNode();
        } else if (!params.isArray() && !params.isObject()) {
            throw new IllegalArgumentException("expected 'params' to be ARRAY or OBJECT but found " + params.getNodeType());
        }
        return new Request(methodName.asText(), idNode, params);
    }

    protected ObjectNode invokeSolo(Request validRequest) {
        Stopwatch timer = Stopwatch.createStarted();
        String methodName = validRequest.getMethodName();
        JsonNode arguments = validRequest.getParams();
        MethodDefinition methodDef = this.methodRegistry.getMethod(methodName).orElse(null);
        JsonRpcLogger.RequestInfo requestInfo = JsonRpcDispatcherImpl.newRequestInfo(methodName, methodDef, arguments);
        try {
            this.jsonRpcLogger.logRequest(requestInfo);
            JsonNode result = this.methodRegistry.invoke(methodName, arguments);
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
            resultMap.put("jsonrpc", "2.0");
            resultMap.put("id", (String)validRequest.getId());
            resultMap.put("result", (String)result);
            ObjectNode response = (ObjectNode)this.getObjectMapper().convertValue(resultMap, ObjectNode.class);
            this.jsonRpcLogger.logSuccessResponse(requestInfo, JsonRpcDispatcherImpl.newResponseInfo(response, timer));
            return response;
        }
        catch (Throwable t) {
            this.jsonRpcLogger.logException(t);
            JsonRpcError jsonRpcError = this.exceptionTranslator.translate(t);
            ObjectNode response = this.buildErrorResponse(jsonRpcError, validRequest.id);
            this.jsonRpcLogger.logErrorResponse(requestInfo, JsonRpcDispatcherImpl.newResponseInfo(response, timer));
            return response;
        }
    }

    protected ObjectNode invokeSolo(JsonNode soloRequest) {
        try {
            return this.invokeSolo(this.validateSoloRequest(soloRequest));
        }
        catch (Throwable t) {
            this.jsonRpcLogger.logException(t);
            JsonRpcError jsonRpcError = this.exceptionTranslator.translate(t);
            return this.buildErrorResponse(jsonRpcError, soloRequest.get("id"));
        }
    }

    private static JsonRpcLogger.RequestInfo newRequestInfo(final String methodName, final @Nullable MethodDefinition methodDef, final JsonNode arguments) {
        return new JsonRpcLogger.RequestInfo(){

            @Override
            public String getMethodName() {
                return methodName;
            }

            @Override
            public Optional<MethodDefinition> getMethodDefinition() {
                return Optional.ofNullable(methodDef);
            }

            @Override
            public JsonNode getArguments() {
                return arguments;
            }
        };
    }

    private static JsonRpcLogger.ResponseInfo newResponseInfo(final ObjectNode response, final Stopwatch timer) {
        return new JsonRpcLogger.ResponseInfo(){

            @Override
            public ObjectNode getResponse() {
                return response;
            }

            @Override
            public Stopwatch getExecutionTimer() {
                return timer;
            }
        };
    }

    protected boolean isValidId(@Nullable JsonNode id) {
        return JacksonHelper.isLikeNull(id) || id.isNumber() || id.isTextual();
    }

    protected ObjectNode buildErrorResponse(JsonRpcError jsonRpcError, @Nullable JsonNode id) {
        if (!this.isValidId(id)) {
            id = null;
        }
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("jsonrpc", "2.0");
        response.put("id", id);
        response.put("error", jsonRpcError);
        return (ObjectNode)this.getObjectMapper().convertValue(response, ObjectNode.class);
    }

    protected ArrayNode invokeBatch(ArrayNode batchRequest) {
        if (batchRequest.size() == 0) {
            throw new InvalidRequestException("batch must not be empty");
        }
        ArrayList<Future<JsonNode>> futureResults = new ArrayList<Future<JsonNode>>();
        for (JsonNode soloRequest : batchRequest) {
            boolean bl = JacksonHelper.isLikeNull(soloRequest.get("id")) && this.isValidSoloRequest(soloRequest);
            Future<JsonNode> future = this.executorService.submit(() -> this.invokeSolo(soloRequest));
            if (bl) continue;
            futureResults.add(future);
        }
        ArrayNode response = this.newArray();
        for (Future future : futureResults) {
            try {
                response.add((JsonNode)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new InternalErrorException(e);
            }
        }
        return response;
    }

    protected static class Request {
        private final String methodName;
        private final JsonNode id;
        private final JsonNode params;

        public Request(String methodName, JsonNode id, JsonNode params) {
            this.methodName = methodName;
            this.id = id;
            this.params = params;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public JsonNode getId() {
            return this.id;
        }

        public JsonNode getParams() {
            return this.params;
        }
    }
}

