/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.jsonrpc.client.JsonRpcTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class JdkHttpJsonRpcTransport
implements JsonRpcTransport {
    private final URL endpoint;
    private int connectionTimeoutMillis;
    private int readTimeoutMillis;

    public JdkHttpJsonRpcTransport(String endpoint) {
        try {
            this.endpoint = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to parse endpoint url", e);
        }
        this.setConnectionTimeout(30L, TimeUnit.SECONDS);
        this.setReadTimeout(30L, TimeUnit.SECONDS);
    }

    public void setConnectionTimeout(long duration, TimeUnit unit) {
        this.connectionTimeoutMillis = (int)unit.toMillis(duration);
    }

    public void setReadTimeout(long duration, TimeUnit unit) {
        this.readTimeoutMillis = (int)unit.toMillis(duration);
    }

    @Override
    public JsonNode execute(ObjectMapper objectMapper, Object jsonRpcRequest) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.endpoint.openConnection();
        try {
            JsonNode jsonNode;
            block17: {
                connection.setConnectTimeout(this.connectionTimeoutMillis);
                connection.setReadTimeout(this.readTimeoutMillis);
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json");
                try (OutputStream output = connection.getOutputStream();){
                    objectMapper.writeValue(output, jsonRpcRequest);
                }
                int statusCode = connection.getResponseCode();
                if (statusCode != 200) {
                    throw new IOException("Server returned HTTP status code " + statusCode);
                }
                InputStream response = connection.getInputStream();
                try {
                    jsonNode = objectMapper.readTree(response);
                    if (response == null) break block17;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonNode;
        }
        finally {
            connection.disconnect();
        }
    }
}

