/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.therapi.core.MethodIntrospector;
import com.github.therapi.core.StandardMethodIntrospector;
import com.github.therapi.core.internal.JacksonHelper;
import com.github.therapi.core.internal.LangHelper;
import com.github.therapi.jsonrpc.JsonRpcError;
import com.github.therapi.jsonrpc.client.JsonRpcException;
import com.github.therapi.jsonrpc.client.JsonRpcTransport;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceFactory {
    protected final MethodIntrospector methodIntrospector;
    protected final ObjectMapper objectMapper;
    protected final JsonRpcTransport transport;
    protected boolean useNamedArguments;

    public ServiceFactory(ObjectMapper objectMapper, JsonRpcTransport transport) {
        this(new StandardMethodIntrospector(objectMapper), objectMapper, transport);
    }

    public ServiceFactory(MethodIntrospector methodIntrospector, ObjectMapper objectMapper, JsonRpcTransport transport) {
        this.methodIntrospector = methodIntrospector;
        this.objectMapper = objectMapper;
        this.transport = transport;
    }

    public void setUseNamedArguments(boolean useNamedArguments) {
        this.useNamedArguments = useNamedArguments;
    }

    public <T> T createService(Class<T> serviceInterface) {
        String namespace = this.getNamespace(serviceInterface);
        return serviceInterface.cast(Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (proxy, method, args) -> {
            try {
                String qualifiedName = namespace.isEmpty() ? method.getName() : namespace + "." + method.getName();
                ObjectNode request = this.createJsonRpcRequest(method, qualifiedName, args);
                JsonNode jsonRpcResponse = this.transport.execute(this.objectMapper, request);
                JsonNode result = jsonRpcResponse.get("result");
                if (result == null) {
                    JsonNode error = jsonRpcResponse.get("error");
                    if (error == null) {
                        throw new IOException("invalid json-rpc response");
                    }
                    throw new JsonRpcException((JsonRpcError)this.objectMapper.convertValue((Object)error, JsonRpcError.class));
                }
                if (method.getReturnType() == Void.TYPE) {
                    return null;
                }
                return this.objectMapper.convertValue((Object)result, JacksonHelper.getReturnTypeReference(method, serviceInterface));
            }
            catch (Exception e) {
                throw LangHelper.propagate(e);
            }
        }));
    }

    protected <T> String getNamespace(Class<T> serviceInterface) {
        return this.methodIntrospector.getNamespace(serviceInterface);
    }

    protected List<String> getParameterNames(Method m) {
        return Arrays.stream(m.getParameters()).map(Parameter::getName).collect(Collectors.toList());
    }

    protected ObjectNode createJsonRpcRequest(Method method, String methodName, Object ... params) {
        ObjectNode request = this.objectMapper.createObjectNode().put("jsonrpc", "2.0").put("id", "").put("method", methodName);
        if (params == null) {
            return request;
        }
        if (this.useNamedArguments) {
            ObjectNode argsNode = this.objectMapper.createObjectNode();
            int index = 0;
            for (String paramName : this.getParameterNames(method)) {
                argsNode.putPOJO(paramName, params[index++]);
            }
            request.set("params", (JsonNode)argsNode);
        } else {
            ArrayNode argsNode = this.objectMapper.createArrayNode();
            for (Object arg : params) {
                argsNode.addPOJO(arg);
            }
            request.set("params", (JsonNode)argsNode);
        }
        return request;
    }
}

