/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc.web;

import com.github.therapi.apidoc.ApiDocProvider;
import com.github.therapi.apidoc.ApiDocWriter;
import com.github.therapi.apidoc.ApiModelDoc;
import com.github.therapi.apidoc.ModelDocWriter;
import com.github.therapi.core.MethodDefinition;
import com.github.therapi.core.MethodRegistry;
import com.github.therapi.core.ParameterDefinition;
import com.github.therapi.jsonrpc.web.JsonRpcServletHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractJsonRpcServlet
extends HttpServlet {
    private JsonRpcServletHandler handler;

    protected void setHandler(JsonRpcServletHandler handler) {
        this.handler = Objects.requireNonNull(handler);
    }

    protected JsonRpcServletHandler getHandler() {
        Preconditions.checkState((this.handler != null ? 1 : 0) != 0, (Object)"handler not initialized; must call setHandler first");
        return this.handler;
    }

    protected MethodRegistry getMethodRegistry() {
        return this.getHandler().getRegistry();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.getHandler().handlePost(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            if ("/apidoc".equals(req.getPathInfo())) {
                this.sendApiDoc(req, resp);
                return;
            }
            if (pathInfo.startsWith("/modeldoc/")) {
                this.sendModelDoc(req, resp, StringUtils.removeStart((String)pathInfo, (String)"/modeldoc/"));
                return;
            }
            if ("/client.js".equals(req.getPathInfo())) {
                this.sendJavascriptClient(req, resp);
                return;
            }
        }
        this.getHandler().handleGet(req, resp);
    }

    protected void sendApiDoc(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ApiDocProvider provider = new ApiDocProvider();
        resp.setContentType("text/html;charset=UTF-8");
        this.getApiDocWriter().writeTo(provider.getDocumentation(this.getMethodRegistry()), resp.getWriter());
    }

    protected ApiDocWriter getApiDocWriter() {
        return new ApiDocWriter();
    }

    protected void sendModelDoc(HttpServletRequest req, HttpServletResponse resp, String modelClassName) throws IOException, ServletException {
        ApiDocProvider provider = new ApiDocProvider();
        ApiModelDoc modelDoc = provider.getModelDocumentation(this.handler.getRegistry(), modelClassName).orElse(null);
        if (modelDoc == null) {
            resp.sendError(404, "Model class not found: " + modelClassName);
            return;
        }
        resp.setContentType("text/html;charset=UTF-8");
        this.getModelDocWriter().writeTo(modelDoc, resp.getWriter());
    }

    protected ModelDocWriter getModelDocWriter() {
        return new ModelDocWriter();
    }

    private void sendJavascriptClient(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        writer.println("\nfunction JsonRpcError(jsonRpcErrorResponse) {\n    this.name = \"JsonRpcError\";\n    this.code = jsonRpcErrorResponse.code;\n    this.message = jsonRpcErrorResponse.message;\n    this.data = jsonRpcErrorResponse.data;\n    this.stack = (new Error()).stack;\n}\nJsonRpcError.prototype = Object.create(Error.prototype);\nJsonRpcError.prototype.constructor = JsonRpcError;");
        writer.println();
        writer.println("logit = function(x) { if (x instanceof JsonRpcError) { logerr(x);} else {console.debug(x);} };");
        writer.println("logerr = function(x) { console.warn(x); if (x.data && x.data.detail) {console.warn(x.data.detail);}};");
        writer.println("rethrow = function(e) { throw e; };");
        writer.println();
        writer.println("Therapi = {}");
        HashSet<String> definedNamespaces = new HashSet<String>();
        for (MethodDefinition mdef : this.getMethodRegistry().getMethods()) {
            int i;
            writer.println("console.debug('" + mdef.getQualifiedName(".") + "')");
            String[] components = mdef.getQualifiedName(".").split("\\.");
            StringBuilder namespaceFragment = new StringBuilder();
            for (i = 0; i < components.length - 1; ++i) {
                if (i > 0) {
                    namespaceFragment.append(".");
                }
                namespaceFragment.append(components[i]);
                if (!definedNamespaces.add(namespaceFragment.toString())) continue;
                writer.println("Therapi." + namespaceFragment + " = {}");
            }
            writer.print("Therapi." + mdef.getQualifiedName(".") + " = function(");
            i = 0;
            StringBuilder paramMap = new StringBuilder();
            for (ParameterDefinition pdef : mdef.getParameters()) {
                writer.print(pdef.getName());
                paramMap.append(pdef.getName() + ": " + pdef.getName());
                if (++i >= mdef.getParameters().size()) continue;
                writer.print(", ");
                paramMap.append(", ");
            }
            writer.println(") {");
            writer.println("    return new Promise(function (resolve, reject) {\n        $.jsonRPC.request('" + mdef.getQualifiedName(".") + "', {\n            params: {" + paramMap + "},\n            success: function (result) {\n                resolve(result.result);\n            },\n            error: function (result) {\n                reject(new JsonRpcError(result.error));\n            }\n        });\n    });\n};\n");
        }
    }
}

