/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.apidoc.ApiDocProvider;
import com.github.therapi.apidoc.ApiDocWriter;
import com.github.therapi.apidoc.ApiModelDoc;
import com.github.therapi.apidoc.ModelDocWriter;
import com.github.therapi.core.MethodRegistry;
import com.github.therapi.core.annotation.Remotable;
import com.github.therapi.jsonrpc.JsonRpcDispatcher;
import com.github.therapi.jsonrpc.web.JsonRpcServletHandler;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/jsonrpc"})
public abstract class AbstractSpringJsonRpcController
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSpringJsonRpcController.class);
    protected JsonRpcServletHandler handler;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        MethodRegistry registry = this.newMethodRegistry();
        this.registerRemotableBeans(registry, (ListableBeanFactory)event.getApplicationContext());
        this.postProcessRegistry(registry);
        this.handler = new JsonRpcServletHandler(this.newJsonRpcDispatcher(registry), this.getDefaultResponseFormat());
    }

    protected JsonRpcServletHandler.ResponseFormat getDefaultResponseFormat() {
        return JsonRpcServletHandler.ResponseFormat.PRETTY;
    }

    protected JsonRpcDispatcher newJsonRpcDispatcher(MethodRegistry registry) {
        return JsonRpcDispatcher.builder(registry).build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handler.handleGet(req, resp);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handler.handlePost(req, resp);
    }

    @RequestMapping(path={"/apidoc"}, method={RequestMethod.GET})
    public void sendApiDoc(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ApiDocProvider provider = new ApiDocProvider();
        resp.setContentType("text/html;charset=UTF-8");
        this.getApiDocWriter().writeTo(provider.getDocumentation(this.handler.getRegistry()), resp.getWriter());
    }

    @RequestMapping(path={"/modeldoc/{modelClassName:.+}"}, method={RequestMethod.GET})
    public void sendModelDoc(HttpServletRequest req, HttpServletResponse resp, @PathVariable String modelClassName) throws IOException, ServletException {
        ApiDocProvider provider = new ApiDocProvider();
        ApiModelDoc modelDoc = provider.getModelDocumentation(this.handler.getRegistry(), modelClassName).orElse(null);
        if (modelDoc == null) {
            resp.sendError(404, "Model class not found: " + modelClassName);
            return;
        }
        resp.setContentType("text/html;charset=UTF-8");
        this.getModelDocWriter().writeTo(modelDoc, resp.getWriter());
    }

    protected abstract ObjectMapper getObjectMapper();

    protected MethodRegistry newMethodRegistry() {
        return new MethodRegistry(this.getObjectMapper());
    }

    protected void postProcessRegistry(MethodRegistry registry) {
    }

    protected ApiDocWriter getApiDocWriter() {
        return new ApiDocWriter();
    }

    protected ModelDocWriter getModelDocWriter() {
        return new ModelDocWriter();
    }

    protected void registerRemotableBeans(MethodRegistry registry, ListableBeanFactory beanFactory) {
        log.info("Scanning bean factory for remotable services");
        Stopwatch timer = Stopwatch.createStarted();
        for (Map.Entry entry : beanFactory.getBeansWithAnnotation(Remotable.class).entrySet()) {
            String beanName = (String)entry.getKey();
            Object remotableBean = entry.getValue();
            List<String> methodNames = registry.scan(remotableBean);
            log.info("Registering remotable service bean '{}'; found methods: {}", (Object)beanName, methodNames);
        }
        log.info("Scanned bean factory for remotable services in {}", (Object)timer);
    }
}

