/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.jsonrpc.web;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetaInfResourceExporterServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        String resourceName = "/META-INF/resources/therapi" + pathInfo;
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);){
            if (is == null) {
                response.sendError(404, resourceName);
                return;
            }
            String contentType = null;
            if (resourceName.endsWith(".js")) {
                contentType = "text/javascript";
            } else if (resourceName.endsWith(".css")) {
                contentType = "text/css";
            } else if (resourceName.endsWith(".png")) {
                contentType = "image/png";
            }
            if (contentType != null) {
                response.setContentType(contentType);
            }
            try (ServletOutputStream os = response.getOutputStream();){
                int len;
                byte[] buffer = new byte[4096];
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
        }
    }
}

