@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  cbes-checkpoint-clear startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and CBES_CHECKPOINT_CLEAR_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\couchbase-elasticsearch-connector-4.4.14.jar;%APP_HOME%\lib\therapi-json-rpc-0.5.0.jar;%APP_HOME%\lib\guava-33.5.0-jre.jar;%APP_HOME%\lib\dcp-client-0.56.0.jar;%APP_HOME%\lib\java-client-3.9.2.jar;%APP_HOME%\lib\core-io-3.9.2.jar;%APP_HOME%\lib\jspecify-1.0.0.jar;%APP_HOME%\lib\log4j-slf4j2-impl-2.23.1.jar;%APP_HOME%\lib\jcl-over-slf4j-2.0.17.jar;%APP_HOME%\lib\log4j2-ecs-layout-1.6.0.jar;%APP_HOME%\lib\elasticsearch-java-8.17.3.jar;%APP_HOME%\lib\opensearch-java-2.22.0.jar;%APP_HOME%\lib\opensearch-rest-client-2.19.1.jar;%APP_HOME%\lib\httpclient5-5.4.2.jar;%APP_HOME%\lib\sts-2.31.2.jar;%APP_HOME%\lib\aws-query-protocol-2.31.2.jar;%APP_HOME%\lib\aws-core-2.31.2.jar;%APP_HOME%\lib\auth-2.31.2.jar;%APP_HOME%\lib\regions-2.31.2.jar;%APP_HOME%\lib\protocol-core-2.31.2.jar;%APP_HOME%\lib\sdk-core-2.31.2.jar;%APP_HOME%\lib\apache-client-2.31.2.jar;%APP_HOME%\lib\metrics-json-4.2.16.jar;%APP_HOME%\lib\jackson-datatype-jdk8-2.20.0.jar;%APP_HOME%\lib\jackson-module-parameter-names-2.20.0.jar;%APP_HOME%\lib\jackson-module-jsonSchema-2.20.0.jar;%APP_HOME%\lib\kubernetes-httpclient-okhttp-7.0.0.jar;%APP_HOME%\lib\kubernetes-client-7.0.0.jar;%APP_HOME%\lib\kubernetes-httpclient-vertx-7.0.0.jar;%APP_HOME%\lib\kubernetes-client-api-7.0.0.jar;%APP_HOME%\lib\zjsonpatch-7.0.0.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.20.0.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.20.0.jar;%APP_HOME%\lib\kubernetes-model-gatewayapi-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-resource-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-rbac-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-admissionregistration-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-apps-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-autoscaling-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-apiextensions-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-batch-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-certificates-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-coordination-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-discovery-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-events-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-extensions-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-flowcontrol-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-networking-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-metrics-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-policy-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-scheduling-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-storageclass-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-node-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-core-7.0.0.jar;%APP_HOME%\lib\kubernetes-model-common-7.0.0.jar;%APP_HOME%\lib\jackson-databind-2.20.0.jar;%APP_HOME%\lib\vertx-web-client-4.5.11.jar;%APP_HOME%\lib\vertx-web-common-4.5.11.jar;%APP_HOME%\lib\vertx-auth-common-4.5.11.jar;%APP_HOME%\lib\vertx-core-4.5.11.jar;%APP_HOME%\lib\jackson-core-2.20.0.jar;%APP_HOME%\lib\micrometer-registry-prometheus-1.10.5.jar;%APP_HOME%\lib\metrics-jvm-4.2.16.jar;%APP_HOME%\lib\commons-text-1.14.0.jar;%APP_HOME%\lib\tuweni-toml-2.0.0.jar;%APP_HOME%\lib\jopt-simple-5.0.4.jar;%APP_HOME%\lib\picocli-4.7.1.jar;%APP_HOME%\lib\logging-interceptor-4.12.0.jar;%APP_HOME%\lib\okhttp-4.12.0.jar;%APP_HOME%\lib\http-auth-aws-2.31.2.jar;%APP_HOME%\lib\http-auth-2.31.2.jar;%APP_HOME%\lib\http-auth-spi-2.31.2.jar;%APP_HOME%\lib\identity-spi-2.31.2.jar;%APP_HOME%\lib\profiles-2.31.2.jar;%APP_HOME%\lib\netty-nio-client-2.31.2.jar;%APP_HOME%\lib\http-client-spi-2.31.2.jar;%APP_HOME%\lib\json-utils-2.31.2.jar;%APP_HOME%\lib\metrics-spi-2.31.2.jar;%APP_HOME%\lib\checksums-2.31.2.jar;%APP_HOME%\lib\retries-2.31.2.jar;%APP_HOME%\lib\retries-spi-2.31.2.jar;%APP_HOME%\lib\utils-2.31.2.jar;%APP_HOME%\lib\http-auth-aws-eventstream-2.31.2.jar;%APP_HOME%\lib\endpoints-spi-2.31.2.jar;%APP_HOME%\lib\checksums-spi-2.31.2.jar;%APP_HOME%\lib\annotations-2.31.2.jar;%APP_HOME%\lib\third-party-jackson-core-2.31.2.jar;%APP_HOME%\lib\netty-codec-http2-4.1.119.Final.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.119.Final.jar;%APP_HOME%\lib\netty-codec-http-4.1.119.Final.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.119.Final.jar;%APP_HOME%\lib\netty-handler-4.1.119.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.119.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.119.Final.jar;%APP_HOME%\lib\netty-codec-4.1.119.Final.jar;%APP_HOME%\lib\netty-transport-classes-epoll-4.1.119.Final.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.119.Final.jar;%APP_HOME%\lib\netty-transport-4.1.119.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.119.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.119.Final.jar;%APP_HOME%\lib\netty-common-4.1.119.Final.jar;%APP_HOME%\lib\jackson-annotations-2.20.jar;%APP_HOME%\lib\micrometer-core-1.10.5.jar;%APP_HOME%\lib\micrometer-observation-1.10.5.jar;%APP_HOME%\lib\micrometer-commons-1.10.5.jar;%APP_HOME%\lib\log4j-core-2.23.1.jar;%APP_HOME%\lib\log4j-api-2.23.1.jar;%APP_HOME%\lib\metrics-core-4.2.16.jar;%APP_HOME%\lib\slf4j-api-2.0.17.jar;%APP_HOME%\lib\ecs-logging-core-1.6.0.jar;%APP_HOME%\lib\elasticsearch-rest-client-8.17.3.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\parsson-1.1.6.jar;%APP_HOME%\lib\yasson-2.0.2.jar;%APP_HOME%\lib\jakarta.json-api-2.1.3.jar;%APP_HOME%\lib\opentelemetry-api-1.29.0.jar;%APP_HOME%\lib\jakarta.json.bind-api-2.0.0.jar;%APP_HOME%\lib\jakarta.annotation-api-1.3.5.jar;%APP_HOME%\lib\httpcore5-h2-5.3.3.jar;%APP_HOME%\lib\httpcore5-5.3.3.jar;%APP_HOME%\lib\httpclient-4.5.14.jar;%APP_HOME%\lib\httpcore-4.4.16.jar;%APP_HOME%\lib\httpasyncclient-4.1.5.jar;%APP_HOME%\lib\httpcore-nio-4.4.16.jar;%APP_HOME%\lib\commons-codec-1.17.1.jar;%APP_HOME%\lib\reactor-core-3.6.9.jar;%APP_HOME%\lib\reactive-streams-1.0.4.jar;%APP_HOME%\lib\commons-lang3-3.18.0.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\therapi-runtime-javadoc-0.12.0.jar;%APP_HOME%\lib\failureaccess-1.0.3.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\error_prone_annotations-2.41.0.jar;%APP_HOME%\lib\j2objc-annotations-3.1.jar;%APP_HOME%\lib\antlr4-runtime-4.7.1.jar;%APP_HOME%\lib\okio-jvm-3.6.0.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.9.10.jar;%APP_HOME%\lib\eventstream-1.0.1.jar;%APP_HOME%\lib\simpleclient_common-0.16.0.jar;%APP_HOME%\lib\HdrHistogram-2.1.12.jar;%APP_HOME%\lib\LatencyUtils-2.0.3.jar;%APP_HOME%\lib\opentelemetry-context-1.29.0.jar;%APP_HOME%\lib\jakarta.json-2.0.0-module.jar;%APP_HOME%\lib\validation-api-1.1.0.Final.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.9.10.jar;%APP_HOME%\lib\kotlin-stdlib-1.9.10.jar;%APP_HOME%\lib\snakeyaml-engine-2.8.jar;%APP_HOME%\lib\simpleclient-0.16.0.jar;%APP_HOME%\lib\snakeyaml-2.4.jar;%APP_HOME%\lib\javax.annotation-api-1.3.2.jar;%APP_HOME%\lib\simpleclient_tracer_otel-0.16.0.jar;%APP_HOME%\lib\simpleclient_tracer_otel_agent-0.16.0.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.9.10.jar;%APP_HOME%\lib\annotations-13.0.jar;%APP_HOME%\lib\simpleclient_tracer_common-0.16.0.jar


@rem Execute cbes-checkpoint-clear
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %CBES_CHECKPOINT_CLEAR_OPTS%  -classpath "%CLASSPATH%" com.couchbase.connector.elasticsearch.cli.CheckpointClear %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable CBES_CHECKPOINT_CLEAR_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%CBES_CHECKPOINT_CLEAR_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
