/* -*- Mode: C++; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * Copyright 2022-Present Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
 * ANY KIND, either express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

#pragma once

#include <memory>

namespace couchbase::core
{
class agent_impl;
class collections_component_unit_test_api;

class agent_unit_test_api
{
public:
  [[nodiscard]] auto collections() -> collections_component_unit_test_api;

private:
  friend class agent;

  explicit agent_unit_test_api(std::shared_ptr<agent_impl>);

  std::shared_ptr<agent_impl> impl_;
};
} // namespace couchbase::core
