/* -*- Mode: C++; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 *   Copyright 2024. Couchbase, Inc.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

#include "error.hxx"

#include <tao/json/to_string.hpp>

#include <string>

namespace couchbase::core::columnar
{
error::
operator bool() const
{
  return ec.operator bool();
}

auto
error::message_with_ctx() const -> std::string
{
  std::string serialized_ctx{};
  if (!ctx.get_object().empty()) {
    serialized_ctx = tao::json::to_string(ctx);
  }
  std::string res{};
  if (!message.empty()) {
    res += message;
  }
  if (!serialized_ctx.empty()) {
    if (!res.empty()) {
      res += ' ';
    }
    res += serialized_ctx;
  }
  return res;
}
} // namespace couchbase::core::columnar
