/* -*- Mode: C++; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 *   Copyright 2023-Present Couchbase, Inc.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

#pragma once

#include <couchbase/common_options.hxx>
#include <couchbase/error_codes.hxx>

#include <cstdint>
#include <functional>
#include <map>
#include <string>

namespace couchbase
{
class get_pending_mutations_analytics_options
  : public common_options<get_pending_mutations_analytics_options>
{
public:
  /**
   * Immutable value object representing consistent options.
   *
   * @since 1.0.0
   * @internal
   */
  struct built : public common_options<get_pending_mutations_analytics_options>::built {
  };

  /**
   * Validates options and returns them as an immutable value.
   *
   * @return consistent options as an immutable value
   *
   * @exception std::system_error with code errc::common::invalid_argument if the options are not
   * valid
   *
   * @since 1.0.0
   * @internal
   */
  [[nodiscard]] auto build() const -> built
  {
    return { build_common_options() };
  }
};

/**
 * The signature for the handler of the @ref analytics_index_manager#get_pending_mutations()
 * operation
 *
 * @since 1.0.0
 * @uncommitted
 */
using get_pending_mutations_analytics_handler =
  std::function<void(error, std::map<std::string, std::map<std::string, std::int64_t>>)>;
} // namespace couchbase
