/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.vector;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.vector.CoreVector;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Validators;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreVectorQuery {
    public static final int DEFAULT_NUM_CANDIDATES = 3;
    private final CoreVector vector;
    private final String field;
    @Nullable
    private final Integer numCandidates;
    @Nullable
    private final Double boost;
    @Nullable
    private final CoreSearchQuery prefilter;

    public CoreVectorQuery(CoreVector vector, String field, @Nullable Integer numCandidates, @Nullable Double boost, @Nullable CoreSearchQuery prefilter) {
        this.vector = Objects.requireNonNull(vector);
        this.numCandidates = numCandidates;
        this.field = Validators.notNullOrEmpty(field, "Field");
        this.boost = boost;
        this.prefilter = prefilter;
        if (numCandidates != null && numCandidates < 1) {
            throw InvalidArgumentException.fromMessage("If numCandidates is specified, it must be >= 1, but got: " + numCandidates);
        }
    }

    public ObjectNode toJson() {
        ObjectNode outer = Mapper.createObjectNode();
        outer.put("field", this.field);
        outer.put("k", this.numCandidates != null ? this.numCandidates : 3);
        if (this.prefilter != null) {
            outer.set("filter", this.prefilter.export());
        }
        if (this.boost != null) {
            outer.put("boost", this.boost);
        }
        this.vector.writeTo(outer);
        return outer;
    }
}

