/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.collector;

import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryCounterType;
import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryHistogram;
import com.couchbase.client.core.cnc.apptelemetry.collector.Reportable;
import com.couchbase.client.core.service.ServiceType;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;

class AppTelemetryCounter
implements Reportable {
    private final String name;
    private final LongAdder count = new LongAdder();

    AppTelemetryCounter(ServiceType serviceType, AppTelemetryCounterType type) {
        this.name = "sdk_" + serviceType.id() + "_" + type.name;
    }

    public void increment() {
        this.count.increment();
    }

    @Override
    public void reportTo(Consumer<? super CharSequence> charSink, Map<String, String> commonTags, long currentTimeMillis) {
        long value = this.count.sumThenReset();
        if (value == 0L) {
            return;
        }
        charSink.accept(this.name);
        charSink.accept(AppTelemetryHistogram.formatTags(commonTags));
        charSink.accept(" ");
        charSink.accept(Long.toString(value));
        charSink.accept(" ");
        charSink.accept(Long.toString(currentTimeMillis));
        charSink.accept("\n");
    }
}

