/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.config.BucketConfigUpdatedEvent;
import com.couchbase.client.core.cnc.events.config.BucketOpenRetriedEvent;
import com.couchbase.client.core.cnc.events.config.CollectionMapRefreshFailedEvent;
import com.couchbase.client.core.cnc.events.config.CollectionMapRefreshIgnoredEvent;
import com.couchbase.client.core.cnc.events.config.CollectionMapRefreshSucceededEvent;
import com.couchbase.client.core.cnc.events.config.ConfigIgnoredEvent;
import com.couchbase.client.core.cnc.events.config.ConfigPushFailedEvent;
import com.couchbase.client.core.cnc.events.config.DnsSrvRefreshAttemptCompletedEvent;
import com.couchbase.client.core.cnc.events.config.DnsSrvRefreshAttemptFailedEvent;
import com.couchbase.client.core.cnc.events.config.GlobalConfigRetriedEvent;
import com.couchbase.client.core.cnc.events.config.GlobalConfigUpdatedEvent;
import com.couchbase.client.core.cnc.events.config.IndividualGlobalConfigLoadFailedEvent;
import com.couchbase.client.core.cnc.events.config.SeedNodesUpdateFailedEvent;
import com.couchbase.client.core.cnc.events.config.SeedNodesUpdatedEvent;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigRefreshFailure;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.GlobalConfig;
import com.couchbase.client.core.config.LegacyConfigHelper;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.ProposedGlobalConfigContext;
import com.couchbase.client.core.config.TopologyChangeNotificationBuffer;
import com.couchbase.client.core.config.loader.ClusterManagerBucketLoader;
import com.couchbase.client.core.config.loader.GlobalLoader;
import com.couchbase.client.core.config.loader.KeyValueBucketLoader;
import com.couchbase.client.core.config.refresher.ClusterManagerBucketRefresher;
import com.couchbase.client.core.config.refresher.GlobalRefresher;
import com.couchbase.client.core.config.refresher.KeyValueBucketRefresher;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.AlreadyShutdownException;
import com.couchbase.client.core.error.BucketNotFoundDuringLoadException;
import com.couchbase.client.core.error.BucketNotReadyDuringLoadException;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.NoAccessDuringConfigLoadException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.SeedNodeOutdatedException;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.client.core.error.UnsupportedConfigMechanismException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.CollectionMap;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetCollectionIdRequest;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.BucketTopology;
import com.couchbase.client.core.topology.ClusterTopology;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.CouchbaseBucketTopology;
import com.couchbase.client.core.topology.NetworkSelector;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.topology.PortSelector;
import com.couchbase.client.core.topology.TopologyParser;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.core.util.NanoTimestamp;
import com.couchbase.client.core.util.UnsignedLEB128;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.Nullable;
import reactor.util.retry.Retry;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationProvider.class);
    private static final Duration MIN_TIME_BETWEEN_DNS_LOOKUPS = Duration.ofSeconds(10L);
    private static final int DEFAULT_KV_PORT = 11210;
    private static final int DEFAULT_MANAGER_PORT = 8091;
    private static final int DEFAULT_KV_TLS_PORT = 11207;
    private static final int DEFAULT_MANAGER_TLS_PORT = 18091;
    private static final int MAX_PARALLEL_LOADERS = 5;
    private final Core core;
    private final EventBus eventBus;
    @Nullable
    private volatile TopologyParser topologyParser;
    private final KeyValueBucketLoader keyValueLoader;
    private final ClusterManagerBucketLoader clusterManagerLoader;
    private final KeyValueBucketRefresher keyValueRefresher;
    private final ClusterManagerBucketRefresher clusterManagerRefresher;
    private final GlobalLoader globalLoader;
    private final GlobalRefresher globalRefresher;
    private final Sinks.Many<ClusterConfig> configsSink = Sinks.many().replay().latest();
    private final Flux<ClusterConfig> configs = this.configsSink.asFlux();
    private final ClusterConfig currentConfig = new ClusterConfig();
    private final Disposable seedNodeResolver;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final CollectionMap collectionMap = new CollectionMap();
    private volatile boolean globalConfigLoadInProgress = false;
    private final AtomicInteger bucketConfigLoadInProgress = new AtomicInteger();
    final Set<CollectionIdentifier> collectionMapRefreshInProgress = ConcurrentHashMap.newKeySet();
    private final AtomicReference<Set<SeedNode>> currentSeedNodes = new AtomicReference(Collections.emptySet());
    private final Sinks.Many<Set<SeedNode>> seedNodesSink = Sinks.many().replay().latest();
    private final Flux<Set<SeedNode>> seedNodes = this.seedNodesSink.asFlux();
    private final ConnectionString connectionString;
    private volatile NanoTimestamp lastDnsSrvLookup = NanoTimestamp.never();
    private final Sinks.Many<ConfigurationProvider.TopologyPollingTrigger> topologyPollingTriggers = Sinks.many().multicast().onBackpressureBuffer(1);
    private final TopologyChangeNotificationBuffer topologyChangeNotificationBuffer = new TopologyChangeNotificationBuffer();
    private static final TopologyRevision NEWER_THAN_WHAT_WE_HAVE = new TopologyRevision(Long.MAX_VALUE, Long.MAX_VALUE){

        @Override
        public String toString() {
            return "?.?";
        }
    };

    public DefaultConfigurationProvider(Core core, ConnectionString connectionString) {
        this.core = core;
        this.eventBus = core.context().environment().eventBus();
        this.connectionString = Objects.requireNonNull(connectionString);
        this.seedNodeResolver = this.launchSeedNodeResolver(connectionString, core.environment());
        this.keyValueLoader = new KeyValueBucketLoader(core);
        this.clusterManagerLoader = new ClusterManagerBucketLoader(core);
        this.keyValueRefresher = new KeyValueBucketRefresher(this, core);
        this.clusterManagerRefresher = new ClusterManagerBucketRefresher(this, core);
        this.globalLoader = new GlobalLoader(core);
        this.globalRefresher = new GlobalRefresher(this, core);
        this.configsSink.emitNext((Object)this.currentConfig, Reactor.emitFailureHandler());
    }

    private Disposable launchSeedNodeResolver(ConnectionString connectionString, CoreEnvironment env) {
        return Mono.fromRunnable(() -> {
            Set<SeedNode> seedNodes = ConnectionStringUtil.seedNodesFromConnectionString(connectionString, env.ioConfig().dnsSrvEnabled(), env.securityConfig().tlsEnabled(), env.eventBus());
            this.topologyParser = DefaultConfigurationProvider.createTopologyParser(this.core.environment(), seedNodes);
            Reactor.ignoreIfDone(this.setSeedNodes(seedNodes)).orThrow();
            log.info("Resolved seed nodes: {}", (Object)RedactableArgument.redactSystem(seedNodes));
        }).subscribeOn(Schedulers.boundedElastic()).doOnError(t -> log.warn("Seed node resolution failed. Will try again after a brief delay. Cause:", t)).retryWhen((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(10L)).maxBackoff(Duration.ofSeconds(60L)).jitter(1.0)).subscribe();
    }

    private static TopologyParser createTopologyParser(CoreEnvironment env, Set<SeedNode> seedNodes) {
        boolean tls = env.securityConfig().tlsEnabled();
        return new TopologyParser(NetworkSelector.create(env.ioConfig().networkResolution(), DefaultConfigurationProvider.makeDefaultPortsExplicitForNetworkDetection(seedNodes, tls)), tls ? PortSelector.TLS : PortSelector.NON_TLS, env.ioConfig().memcachedHashingStrategy());
    }

    private static Set<SeedNode> makeDefaultPortsExplicitForNetworkDetection(Set<SeedNode> seedNodes, boolean tls) {
        return seedNodes.stream().map(it -> {
            if (it.kvPort().isPresent() || it.clusterManagerPort().isPresent()) {
                return it;
            }
            return it.withKvPort(tls ? 11207 : 11210).withManagerPort(tls ? 18091 : 8091);
        }).collect(Collectors.toSet());
    }

    @Override
    public CollectionMap collectionMap() {
        return this.collectionMap;
    }

    @Override
    public Flux<ClusterConfig> configs() {
        return this.configs;
    }

    @Override
    public ClusterConfig config() {
        return this.currentConfig;
    }

    @Override
    public Flux<Set<SeedNode>> seedNodes() {
        return this.seedNodes;
    }

    private Mono<Set<SeedNode>> waitForSeedNodes() {
        return this.seedNodes.next().switchIfEmpty(Mono.error((Throwable)new AlreadyShutdownException()));
    }

    @Override
    public Mono<Void> openBucket(String name) {
        return Mono.defer(() -> {
            if (!this.shutdown.get()) {
                this.bucketConfigLoadInProgress.incrementAndGet();
                boolean tls = this.core.context().environment().securityConfig().tlsEnabled();
                return this.waitForSeedNodes().flatMap(seedNodes -> this.fetchBucketConfigs(name, (Set<SeedNode>)seedNodes, tls).switchIfEmpty(Mono.error((Throwable)new ConfigException("Could not locate a single bucket configuration for bucket: " + name)))).map(ctx -> {
                    this.proposeBucketConfig((ProposedBucketConfigContext)ctx);
                    return ctx;
                }).then(this.registerRefresher(name)).doOnTerminate(this.bucketConfigLoadInProgress::decrementAndGet).onErrorResume(t -> this.closeBucketIgnoreShutdown(name, true).then(Mono.error((Throwable)t)));
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    protected Mono<ProposedBucketConfigContext> loadBucketConfigForSeed(NodeIdentifier identifier, int mappedKvPort, int mappedManagerPort, String name) {
        return this.keyValueLoader.load(identifier, mappedKvPort, name).onErrorResume(t -> {
            boolean removedWhileOpInFlight = t instanceof ConfigException && t.getCause() instanceof RequestCanceledException && ((RequestCanceledException)t.getCause()).reason() == CancellationReason.TARGET_NODE_REMOVED;
            boolean seedNodeOutdated = t instanceof SeedNodeOutdatedException;
            if (removedWhileOpInFlight || seedNodeOutdated) {
                return Mono.error((Throwable)t);
            }
            return this.clusterManagerLoader.load(identifier, mappedManagerPort, name);
        }).flatMap(ctx -> {
            JsonNode configRoot = Mapper.decodeIntoTree(ctx.config());
            if (configRoot.get("nodes").isEmpty()) {
                return Mono.error((Throwable)new BucketNotReadyDuringLoadException("No KV node in the config (yet), can't use it for now."));
            }
            return Mono.just((Object)ctx);
        });
    }

    @Override
    public Mono<Void> loadAndRefreshGlobalConfig() {
        return Mono.defer(() -> {
            if (!this.shutdown.get()) {
                this.globalConfigLoadInProgress = true;
                boolean tls = this.core.context().environment().securityConfig().tlsEnabled();
                return this.waitForSeedNodes().flatMap(seedNodes -> this.fetchGlobalConfigs((Set<SeedNode>)seedNodes, tls, false, true).switchIfEmpty(Mono.error((Throwable)new ConfigException("Could not locate a single global configuration")))).map(ctx -> {
                    this.proposeGlobalConfig((ProposedGlobalConfigContext)ctx);
                    return ctx;
                }).then(this.globalRefresher.start()).doOnTerminate(() -> {
                    this.globalConfigLoadInProgress = false;
                });
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    private ClusterTopology parseClusterTopology(String json, String origin) {
        TopologyParser parser = this.topologyParser;
        if (parser == null) {
            throw new IllegalStateException("Can't parse cluster topology until seed nodes are resolved.");
        }
        return parser.parse(json, origin);
    }

    @Override
    public void proposeGlobalConfig(ProposedGlobalConfigContext ctx) {
        this.proposeTopology(ctx.config(), ctx.origin(), null, ctx.forcesOverride());
    }

    @Override
    public void proposeBucketConfig(ProposedBucketConfigContext ctx) {
        this.proposeTopology(ctx.config(), ctx.origin(), ctx.bucketName(), ctx.forcesOverride());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proposeTopology(String topologyJson, String origin, @Nullable String bucketName, boolean forceApply) {
        ClusterTopology topology;
        if (this.shutdown.get()) {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.ALREADY_SHUTDOWN, Optional.empty(), Optional.of(topologyJson), Optional.ofNullable(bucketName)));
            return;
        }
        if (topologyJson.isEmpty()) {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.OLD_OR_SAME_REVISION, Optional.empty(), Optional.empty(), Optional.ofNullable(bucketName)));
            return;
        }
        try {
            topology = this.parseClusterTopology(topologyJson, origin);
        }
        catch (Exception ex) {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.PARSE_FAILURE, Optional.of(ex), Optional.of(topologyJson), Optional.ofNullable(bucketName)));
            return;
        }
        DefaultConfigurationProvider defaultConfigurationProvider = this;
        synchronized (defaultConfigurationProvider) {
            try {
                boolean bucketTopologyApplied;
                boolean globalTopologyApplied = this.checkAndApplyGlobalTopology(topology, forceApply);
                log.debug("{} global topology revision {} from origin {}", new Object[]{globalTopologyApplied ? "Applying" : "Ignoring", topology.revision(), origin});
                if (!(topology instanceof ClusterTopologyWithBucket)) {
                    bucketTopologyApplied = false;
                } else {
                    bucketTopologyApplied = this.checkAndApplyBucketTopology(topology.requireBucket(), forceApply);
                    log.debug("{} bucket topology revision {} for bucket [{}] from origin {}", new Object[]{bucketTopologyApplied ? "Applying" : "Ignoring", topology.revision(), topology.requireBucket().bucket().name(), origin});
                }
                if (globalTopologyApplied || bucketTopologyApplied) {
                    this.pushConfig(false);
                }
            }
            catch (Exception e) {
                log.error("Failed to process proposed cluster topology: {}", (Object)RedactableArgument.redactMeta(topology), (Object)e);
            }
        }
    }

    @Override
    public Mono<Void> closeBucket(String name, boolean pushConfig) {
        return Mono.defer(() -> this.shutdown.get() ? Mono.error((Throwable)new AlreadyShutdownException()) : this.closeBucketIgnoreShutdown(name, pushConfig));
    }

    private Mono<Void> closeBucketIgnoreShutdown(String name, boolean pushConfig) {
        return Mono.defer(() -> {
            this.currentConfig.deleteBucketConfig(name);
            if (pushConfig) {
                this.pushConfig(false);
            }
            return Mono.empty();
        }).then(this.keyValueRefresher.deregister(name)).then(this.clusterManagerRefresher.deregister(name));
    }

    @Override
    public Mono<Void> shutdown() {
        return Mono.defer(() -> {
            if (this.shutdown.compareAndSet(false, true)) {
                return Flux.fromIterable(this.currentConfig.bucketConfigs().values()).flatMap(bucketConfig -> this.closeBucketIgnoreShutdown(bucketConfig.name(), false)).then(Mono.defer(this::disableAndClearGlobalConfig)).doOnTerminate(() -> {
                    this.pushConfig(true);
                    this.configsSink.emitComplete(Reactor.emitFailureHandler());
                    this.seedNodesSink.emitComplete(Reactor.emitFailureHandler());
                    this.seedNodeResolver.dispose();
                }).then(this.keyValueRefresher.shutdown()).then(this.clusterManagerRefresher.shutdown()).then(this.globalRefresher.shutdown());
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    private Mono<Void> disableAndClearGlobalConfig() {
        return this.globalRefresher.stop().then(Mono.defer(() -> {
            this.currentConfig.deleteGlobalConfig();
            return Mono.empty();
        }));
    }

    @Override
    public synchronized void refreshCollectionId(CollectionIdentifier identifier) {
        if (this.collectionRefreshInProgress(identifier)) {
            this.eventBus.publish(new CollectionMapRefreshIgnoredEvent(this.core.context(), identifier));
            return;
        }
        this.collectionMapRefreshInProgress.add(identifier);
        NanoTimestamp start = NanoTimestamp.now();
        GetCollectionIdRequest request = new GetCollectionIdRequest(this.core.context().environment().timeoutConfig().kvTimeout(), this.core.context(), (RetryStrategy)BestEffortRetryStrategy.INSTANCE, identifier);
        this.core.send(request);
        request.response().whenComplete((response, throwable) -> {
            try {
                Duration duration = start.elapsed();
                if (throwable != null) {
                    this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), identifier, (Throwable)throwable, CollectionMapRefreshFailedEvent.Reason.FAILED));
                    return;
                }
                if (response.status().success()) {
                    if (response.collectionId().isPresent()) {
                        long cid = response.collectionId().get();
                        this.collectionMap.put(identifier, UnsignedLEB128.encode(cid));
                        this.eventBus.publish(new CollectionMapRefreshSucceededEvent(duration, this.core.context(), identifier, cid));
                    } else {
                        this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), identifier, null, CollectionMapRefreshFailedEvent.Reason.COLLECTION_ID_NOT_PRESENT));
                    }
                } else {
                    CollectionMapRefreshFailedEvent.Reason reason;
                    CouchbaseException cause = null;
                    if (response.status() == ResponseStatus.UNKNOWN || response.status() == ResponseStatus.NO_COLLECTIONS_MANIFEST) {
                        reason = CollectionMapRefreshFailedEvent.Reason.NOT_SUPPORTED;
                    } else if (response.status() == ResponseStatus.UNKNOWN_COLLECTION) {
                        reason = CollectionMapRefreshFailedEvent.Reason.UNKNOWN_COLLECTION;
                    } else if (response.status() == ResponseStatus.UNKNOWN_SCOPE) {
                        reason = CollectionMapRefreshFailedEvent.Reason.UNKNOWN_SCOPE;
                    } else if (response.status() == ResponseStatus.INVALID_REQUEST) {
                        reason = CollectionMapRefreshFailedEvent.Reason.INVALID_REQUEST;
                    } else {
                        cause = new CouchbaseException(response.toString());
                        reason = CollectionMapRefreshFailedEvent.Reason.UNKNOWN;
                    }
                    this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), identifier, cause, reason));
                }
            }
            finally {
                this.collectionMapRefreshInProgress.remove(identifier);
            }
        });
    }

    @Override
    public boolean collectionRefreshInProgress() {
        return !this.collectionMapRefreshInProgress.isEmpty();
    }

    @Override
    public boolean collectionRefreshInProgress(CollectionIdentifier identifier) {
        return this.collectionMapRefreshInProgress.contains(identifier);
    }

    private synchronized boolean checkAndApplyBucketTopology(ClusterTopologyWithBucket newConfig, boolean forceApply) {
        String name = newConfig.bucket().name();
        if (this.shouldIgnore(this.currentConfig.bucketTopology(name), newConfig, forceApply)) {
            return false;
        }
        if (DefaultConfigurationProvider.tainted(newConfig.bucket())) {
            this.keyValueRefresher.markTainted(name);
            this.clusterManagerRefresher.markTainted(name);
        } else {
            this.keyValueRefresher.markUntainted(name);
            this.clusterManagerRefresher.markUntainted(name);
        }
        this.eventBus.publish(new BucketConfigUpdatedEvent(this.core.context(), LegacyConfigHelper.toLegacyBucketConfig(newConfig)));
        this.currentConfig.setBucketConfig(newConfig);
        return true;
    }

    private static boolean tainted(BucketTopology bucketTopology) {
        return bucketTopology instanceof CouchbaseBucketTopology && ((CouchbaseBucketTopology)bucketTopology).partitionsForward().isPresent();
    }

    private synchronized boolean checkAndApplyGlobalTopology(ClusterTopology topology, boolean forceApply) {
        if (this.shouldIgnore(this.currentConfig.globalTopology(), topology, forceApply)) {
            return false;
        }
        this.eventBus.publish(new GlobalConfigUpdatedEvent(this.core.context(), new GlobalConfig(topology)));
        this.currentConfig.setGlobalConfig(topology);
        this.updateSeedNodeList(topology);
        return true;
    }

    private boolean shouldIgnore(@Nullable ClusterTopology current, ClusterTopology proposed, boolean forceApply) {
        if (forceApply || current == null || proposed.revision().newerThan(current.revision())) {
            return false;
        }
        String bucketName = proposed instanceof ClusterTopologyWithBucket ? proposed.requireBucket().bucket().name() : null;
        this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.OLD_OR_SAME_REVISION, Optional.empty(), Optional.empty(), Optional.ofNullable(bucketName)));
        return true;
    }

    private void updateSeedNodeList(ClusterTopology topology) {
        Set<SeedNode> seedNodes = topology.nodes().stream().filter(it -> it.has(ServiceType.KV)).map(it -> SeedNode.create(it.host(), Optional.of(it.ports().get((Object)ServiceType.KV)), Optional.ofNullable(it.ports().get((Object)ServiceType.MANAGER)))).collect(Collectors.toSet());
        if (seedNodes.isEmpty()) {
            log.warn("Cluster topology has no eligible seed nodes; skipping seed node update.");
        } else {
            this.eventBus.publish(new SeedNodesUpdatedEvent(this.core.context(), this.currentSeedNodes(), seedNodes));
            this.setSeedNodes(seedNodes);
        }
    }

    private synchronized void pushConfig(boolean ignoreShutdown) {
        if (ignoreShutdown || !this.shutdown.get()) {
            Sinks.EmitResult emitResult = this.configsSink.tryEmitNext((Object)this.currentConfig);
            if (emitResult != Sinks.EmitResult.OK) {
                this.eventBus.publish(new ConfigPushFailedEvent(this.core.context(), emitResult));
            }
        } else {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.ALREADY_SHUTDOWN, Optional.empty(), Optional.empty(), Optional.empty()));
        }
    }

    @Override
    public void republishCurrentConfig() {
        this.pushConfig(false);
    }

    protected Mono<Void> registerRefresher(String bucket) {
        return Mono.defer(() -> {
            BucketConfig config = this.currentConfig.bucketConfig(bucket);
            if (config == null) {
                return Mono.error((Throwable)new CouchbaseException("Bucket for registration does not exist, this is an error! Please report"));
            }
            if (config instanceof CouchbaseBucketConfig) {
                return this.keyValueRefresher.register(bucket);
            }
            return this.clusterManagerRefresher.register(bucket);
        });
    }

    @Override
    public boolean globalConfigLoadInProgress() {
        return this.globalConfigLoadInProgress;
    }

    @Override
    public boolean bucketConfigLoadInProgress() {
        return this.bucketConfigLoadInProgress.get() > 0;
    }

    @Override
    public void signalConfigRefreshFailed(ConfigRefreshFailure failure) {
        if (failure == ConfigRefreshFailure.ALL_NODES_TRIED_ONCE_WITHOUT_SUCCESS) {
            this.handlePotentialDnsSrvRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalNewTopologyAvailable(@Nullable String bucketName, @Nullable TopologyRevision availableRevision) {
        if (availableRevision == null) {
            availableRevision = NEWER_THAN_WHAT_WE_HAVE;
        }
        if (this.topologyChangeNotificationBuffer.putIfNewer(CbStrings.nullToEmpty(bucketName), availableRevision)) {
            DefaultConfigurationProvider defaultConfigurationProvider = this;
            synchronized (defaultConfigurationProvider) {
                this.topologyPollingTriggers.tryEmitNext((Object)ConfigurationProvider.TopologyPollingTrigger.SERVER_NOTIFICATION);
            }
        }
    }

    @Override
    public Flux<ConfigurationProvider.TopologyPollingTrigger> topologyPollingTriggers(Duration timerInterval) {
        Scheduler scheduler = this.core.context().environment().scheduler();
        return Flux.merge((Publisher[])new Publisher[]{Flux.interval((Duration)timerInterval, (Scheduler)this.core.context().environment().scheduler()).onBackpressureDrop().map(it -> ConfigurationProvider.TopologyPollingTrigger.TIMER), this.topologyPollingTriggers.asFlux().publishOn(scheduler)});
    }

    @Override
    @Nullable
    public TopologyRevision removeTopologyRevisionChangeNotification(@Nullable String bucketName) {
        return this.topologyChangeNotificationBuffer.remove(bucketName);
    }

    private synchronized void handlePotentialDnsSrvRefresh() {
        boolean refreshAllowed;
        CoreContext ctx = this.core.context();
        CoreEnvironment env = ctx.environment();
        boolean isValidDnsSrv = this.connectionString.isValidDnsSrv() && env.ioConfig().dnsSrvEnabled();
        boolean tlsEnabled = env.securityConfig().tlsEnabled();
        boolean enoughTimeElapsed = this.lastDnsSrvLookup.hasElapsed(MIN_TIME_BETWEEN_DNS_LOOKUPS);
        boolean bl = refreshAllowed = isValidDnsSrv && enoughTimeElapsed;
        if (refreshAllowed) {
            this.lastDnsSrvLookup = NanoTimestamp.now();
            NanoTimestamp started = NanoTimestamp.now();
            Schedulers.boundedElastic().schedule(() -> {
                try {
                    List<String> foundNodes = this.performDnsSrvLookup(tlsEnabled);
                    if (foundNodes.isEmpty()) {
                        env.eventBus().publish(new DnsSrvRefreshAttemptFailedEvent(started.elapsed(), ctx, DnsSrvRefreshAttemptFailedEvent.Reason.NO_NEW_SEEDS_RETURNED, null));
                        return;
                    }
                    Set<SeedNode> seedNodes = foundNodes.stream().map(SeedNode::create).collect(Collectors.toSet());
                    ProposedGlobalConfigContext foundGlobalConfig = (ProposedGlobalConfigContext)this.fetchGlobalConfigs(seedNodes, tlsEnabled, true, false).block();
                    if (foundGlobalConfig != null) {
                        this.proposeGlobalConfig(foundGlobalConfig.forceOverride());
                    }
                    for (String name : this.keyValueRefresher.registered()) {
                        ProposedBucketConfigContext bucketConfig = (ProposedBucketConfigContext)this.fetchBucketConfigs(name, seedNodes, tlsEnabled).block();
                        if (bucketConfig == null) continue;
                        this.proposeBucketConfig(bucketConfig.forceOverride());
                    }
                    env.eventBus().publish(new DnsSrvRefreshAttemptCompletedEvent(started.elapsed(), ctx, foundNodes));
                }
                catch (Exception e) {
                    env.eventBus().publish(new DnsSrvRefreshAttemptFailedEvent(started.elapsed(), ctx, DnsSrvRefreshAttemptFailedEvent.Reason.OTHER, e));
                }
            });
        }
    }

    protected List<String> performDnsSrvLookup(boolean tlsEnabled) throws NamingException {
        return ConnectionStringUtil.fromDnsSrvOrThrowIfTlsRequired(this.connectionString.hosts().get(0).host(), tlsEnabled);
    }

    private Mono<ProposedBucketConfigContext> fetchBucketConfigs(String name, Set<SeedNode> seedNodes, boolean tls) {
        int kvPort = tls ? 11207 : 11210;
        int managerPort = tls ? 18091 : 8091;
        return Flux.range((int)1, (int)Math.min(5, seedNodes.size())).flatMap(index -> Flux.fromIterable((Iterable)seedNodes).take((long)Math.min(index, seedNodes.size())).last().flatMap(seed -> {
            NodeIdentifier identifier = NodeIdentifier.forBootstrap(seed.address(), seed.clusterManagerPort().orElse(8091));
            int mappedKvPort = seed.kvPort().orElse(kvPort);
            int mappedManagerPort = seed.clusterManagerPort().orElse(managerPort);
            return this.loadBucketConfigForSeed(identifier, mappedKvPort, mappedManagerPort, name);
        }).retryWhen((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(500L)).maxBackoff(Duration.ofSeconds(10L)).filter(this.bucketConfigLoadRetryFilter(name, t -> DefaultConfigurationProvider.isInstanceOfAnyOf(t, BucketNotFoundDuringLoadException.class, BucketNotReadyDuringLoadException.class, NoAccessDuringConfigLoadException.class)))).retryWhen((Retry)Retry.fixedDelay((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(10L)).filter(this.bucketConfigLoadRetryFilter(name, t -> !(t instanceof UnsupportedConfigMechanismException))))).next();
    }

    private Predicate<? super Throwable> bucketConfigLoadRetryFilter(String bucketName, Predicate<? super Throwable> errorFilter) {
        return t -> {
            if (this.shutdown.get()) {
                throw new AlreadyShutdownException();
            }
            boolean retry = errorFilter.test((Throwable)t);
            if (retry) {
                this.eventBus.publish(new BucketOpenRetriedEvent(bucketName, Duration.ZERO, this.core.context(), (Throwable)t));
            }
            return retry;
        };
    }

    private static boolean isInstanceOfAnyOf(Object o, Class<?> ... candidates) {
        return Arrays.stream(candidates).anyMatch(it -> it.isInstance(o));
    }

    private Mono<ProposedGlobalConfigContext> fetchGlobalConfigs(Set<SeedNode> seedNodes, boolean tls, boolean allowStaleSeeds, boolean retryTimeouts) {
        AtomicBoolean hasErrored = new AtomicBoolean();
        int kvPort = tls ? 11207 : 11210;
        return Flux.range((int)1, (int)Math.min(5, seedNodes.size())).flatMap(index -> Flux.fromIterable((Iterable)seedNodes).take((long)Math.min(index, seedNodes.size())).last().flatMap(seed -> {
            NanoTimestamp start = NanoTimestamp.now();
            if (!allowStaleSeeds && !this.currentSeedNodes().contains(seed)) {
                return Mono.empty();
            }
            NodeIdentifier identifier = NodeIdentifier.forBootstrap(seed.address(), seed.clusterManagerPort().orElse(8091));
            return this.globalLoader.load(identifier, seed.kvPort().orElse(kvPort)).doOnError(throwable -> this.core.context().environment().eventBus().publish(new IndividualGlobalConfigLoadFailedEvent(start.elapsed(), this.core.context(), (Throwable)throwable, seed.address())));
        }).retryWhen(Retry.from(companion -> companion.flatMap(rs -> {
            Throwable f = rs.failure();
            if (this.shutdown.get()) {
                return Mono.error((Throwable)new AlreadyShutdownException());
            }
            if (f instanceof UnsupportedConfigMechanismException) {
                return Mono.error((Throwable)Exceptions.propagate((Throwable)f));
            }
            if (!retryTimeouts && f.getCause() instanceof TimeoutException) {
                return Mono.error((Throwable)f.getCause());
            }
            Duration delay = Duration.ofMillis(1L);
            this.eventBus.publish(new GlobalConfigRetriedEvent(delay, this.core.context(), f));
            return Mono.just((Object)rs.totalRetries()).delayElement(delay, this.core.context().environment().scheduler());
        }))).onErrorResume(throwable -> {
            if (hasErrored.compareAndSet(false, true)) {
                return Mono.error((Throwable)throwable);
            }
            return Mono.empty();
        })).next();
    }

    private Set<SeedNode> currentSeedNodes() {
        return this.currentSeedNodes.get();
    }

    private synchronized Sinks.EmitResult setSeedNodes(Set<SeedNode> seedNodes) {
        this.currentSeedNodes.set(seedNodes);
        Sinks.EmitResult emitResult = this.seedNodesSink.tryEmitNext(seedNodes);
        if (emitResult != Sinks.EmitResult.OK) {
            this.eventBus.publish(new SeedNodesUpdateFailedEvent(this.core.context(), emitResult));
        }
        return emitResult;
    }
}

