/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class Options {
    private static Map<String, String> table;

    private Options() {
    }

    public static void refresh() {
        String s = System.getProperty("dnsjava.options");
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(61);
                if (index == -1) {
                    Options.set(token);
                    continue;
                }
                String option = token.substring(0, index);
                String value = token.substring(index + 1);
                Options.set(option, value);
            }
        }
    }

    public static void clear() {
        table = null;
    }

    public static void set(String option) {
        if (table == null) {
            table = new HashMap<String, String>();
        }
        table.put(option.toLowerCase(), "true");
    }

    public static void set(String option, String value) {
        if (table == null) {
            table = new HashMap<String, String>();
        }
        table.put(option.toLowerCase(), value.toLowerCase());
    }

    public static void unset(String option) {
        if (table == null) {
            return;
        }
        table.remove(option.toLowerCase());
    }

    public static boolean check(String option) {
        if (table == null) {
            return false;
        }
        return table.get(option.toLowerCase()) != null;
    }

    public static String value(String option) {
        if (table == null) {
            return null;
        }
        return table.get(option.toLowerCase());
    }

    public static int intValue(String option) {
        String s = Options.value(option);
        if (s != null) {
            try {
                int val = Integer.parseInt(s);
                if (val > 0) {
                    return val;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    static {
        try {
            Options.refresh();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

