/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.HostAndPort;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SslSessionLoggingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SslSessionLoggingHandler.class);
    public static final SslSessionLoggingHandler INSTANCE = new SslSessionLoggingHandler();

    private SslSessionLoggingHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object event) {
        if (event instanceof SslHandshakeCompletionEvent) {
            try {
                SslHandler handler = ctx.pipeline().get(SslHandler.class);
                SslSessionLoggingHandler.log(handler.engine().getSession());
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            }
            finally {
                ctx.pipeline().remove(this);
                ctx.fireUserEventTriggered(event);
            }
        }
    }

    private static void log(SSLSession session) throws SSLPeerUnverifiedException {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder pemChain = new StringBuilder();
        try {
            for (Certificate cert : session.getPeerCertificates()) {
                String base64Encoded = Base64.getMimeEncoder().encodeToString(cert.getEncoded());
                pemChain.append("-----BEGIN CERTIFICATE-----\n");
                pemChain.append(base64Encoded).append("\n");
                pemChain.append("-----END CERTIFICATE-----\n");
            }
        }
        catch (CertificateEncodingException e) {
            pemChain.setLength(0);
            pemChain.append("Can't display encoded certificate chain; ");
            pemChain.append(CbThrowables.getStackTraceAsString(e));
        }
        log.debug("TLS handshake complete! remote = {} ; cipher suite = {} ; certificate chain = \n{}", new Object[]{new HostAndPort(session.getPeerHost(), session.getPeerPort()), session.getCipherSuite(), pemChain});
    }
}

