/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Objects;

public class HandshakeBarrier
extends ChannelDuplexHandler {
    private ChannelPromise interceptedConnectPromise;

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        this.interceptedConnectPromise = Objects.requireNonNull(promise);
        ChannelPromise downstream = ctx.newPromise();
        downstream.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                this.interceptedConnectPromise.trySuccess();
                ctx.pipeline().remove(this);
                ctx.fireChannelActive();
            } else {
                this.interceptedConnectPromise.tryFailure(f.cause());
            }
        }));
        ctx.connect(remoteAddress, localAddress, downstream);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.interceptedConnectPromise.tryFailure(cause);
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
    }
}

