/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import com.couchbase.client.core.env.SaslMechanism;
import com.couchbase.client.core.io.netty.kv.sasl.OauthBearerSaslClient;
import com.couchbase.client.core.io.netty.kv.sasl.ScramSaslClientFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public class CouchbaseSaslClientFactory
implements SaslClientFactory {
    private static final SaslClientFactory SCRAM_FACTORY = new ScramSaslClientFactory();

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslClient client = SCRAM_FACTORY.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        if (client != null) {
            return client;
        }
        List<String> mechanismList = Arrays.asList(mechanisms);
        if (mechanismList.contains(SaslMechanism.OAUTHBEARER.mech())) {
            return new OauthBearerSaslClient(authorizationId, cbh);
        }
        return Sasl.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{ScramSaslClientFactory.Mode.SCRAM_SHA512.mech(), ScramSaslClientFactory.Mode.SCRAM_SHA256.mech(), ScramSaslClientFactory.Mode.SCRAM_SHA1.mech(), "CRAM-MD5", "PLAIN"};
    }
}

