/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class ClusterIdentifier {
    private final String clusterUuid;
    private final String clusterName;
    private final String product;

    ClusterIdentifier(String clusterUuid, String clusterName, String product) {
        this.clusterUuid = Objects.requireNonNull(clusterUuid);
        this.clusterName = Objects.requireNonNull(clusterName);
        this.product = Objects.requireNonNull(product);
    }

    public static @Nullable ClusterIdentifier parse(ObjectNode config) {
        JsonNode clusterUuid = config.path("clusterUUID");
        JsonNode clusterName = config.path("clusterName");
        if (clusterUuid.isMissingNode() || clusterName.isMissingNode()) {
            return null;
        }
        String prod = config.path("prod").asText("server");
        return new ClusterIdentifier(clusterUuid.asText(), clusterName.asText(), prod);
    }

    public String clusterUuid() {
        return this.clusterUuid;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String product() {
        return this.product;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterIdentifier that = (ClusterIdentifier)o;
        return Objects.equals(this.clusterUuid, that.clusterUuid) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.product, that.product);
    }

    public int hashCode() {
        return Objects.hash(this.clusterUuid, this.clusterName, this.product);
    }

    public String toString() {
        return "ClusterIdent{clusterUuid='" + this.clusterUuid + '\'' + ", clusterName='" + RedactableArgument.redactMeta(this.clusterName) + '\'' + ", product='" + this.product + '\'' + '}';
    }
}

