/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.topology.PortSelector;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.core.util.HostAndPort;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Stability.Internal
class HostAndServicePortsParser {
    private static final TypeReference<Map<String, Integer>> MAP_STRING_TO_INT = new TypeReference<Map<String, Integer>>(){};

    private HostAndServicePortsParser() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Map<NetworkResolution, HostAndServicePorts> parse(ObjectNode json, PortSelector portSelector) {
        Map<NetworkResolution, HostAndRawServicePorts> raw = HostAndServicePortsParser.parseIntermediate(json);
        HostAndPort ketamaAuthority = HostAndServicePortsParser.getKetamaAuthority(raw);
        String serverGroup = json.path("serverGroup").textValue();
        String appTelemetryPath = json.path("appTelemetryPath").textValue();
        String nodeUuid = json.path("nodeUUID").textValue();
        return CbCollections.transformValues(raw, value -> new HostAndServicePorts(((HostAndRawServicePorts)value).host, portSelector.selectPorts(((HostAndRawServicePorts)value).rawServicePorts), HostAndServicePortsParser.getId(((HostAndRawServicePorts)value).host, raw), ketamaAuthority, serverGroup, appTelemetryPath, nodeUuid));
    }

    private static @Nullable HostAndPort getKetamaAuthority(Map<NetworkResolution, HostAndRawServicePorts> networkToNodeInfo) {
        HostAndRawServicePorts defaultNodeMap = networkToNodeInfo.get(NetworkResolution.DEFAULT);
        if (defaultNodeMap == null) {
            return null;
        }
        Integer nonTlsKvPort = HostAndServicePortsParser.getPort(defaultNodeMap, PortSelector.NON_TLS, ServiceType.KV);
        if (nonTlsKvPort == null) {
            return null;
        }
        return new HostAndPort(defaultNodeMap.host, nonTlsKvPort);
    }

    private static NodeIdentifier getId(String hostForNetworkConnections, Map<NetworkResolution, HostAndRawServicePorts> networkToNodeInfo) {
        HostAndRawServicePorts defaultNodeMap = networkToNodeInfo.get(NetworkResolution.DEFAULT);
        if (defaultNodeMap == null) {
            throw new CouchbaseException("Network map is missing entry for default network.");
        }
        Integer idPort = CbObjects.defaultIfNull(HostAndServicePortsParser.getPort(defaultNodeMap, PortSelector.NON_TLS, ServiceType.MANAGER), () -> HostAndServicePortsParser.getPort(defaultNodeMap, PortSelector.TLS, ServiceType.MANAGER));
        if (idPort == null) {
            throw new CouchbaseException("Cluster topology has no manager port on the default network for node: " + RedactableArgument.redactSystem(networkToNodeInfo));
        }
        return new NodeIdentifier(defaultNodeMap.host, idPort, hostForNetworkConnections);
    }

    private static @Nullable Integer getPort(HostAndRawServicePorts nodeMap, PortSelector portSelector, ServiceType serviceType) {
        Map<ServiceType, Integer> ports = portSelector.selectPorts(nodeMap.rawServicePorts);
        return ports.get((Object)serviceType);
    }

    private static Map<NetworkResolution, HostAndRawServicePorts> parseIntermediate(ObjectNode json) {
        HashMap<NetworkResolution, HostAndRawServicePorts> result = new HashMap<NetworkResolution, HostAndRawServicePorts>();
        HostAndRawServicePorts defaultInfo = HostAndServicePortsParser.parseOne(json, "services");
        result.put(NetworkResolution.DEFAULT, defaultInfo);
        json.path("alternateAddresses").fields().forEachRemaining(it -> {
            NetworkResolution network = NetworkResolution.valueOf((String)it.getKey());
            HostAndRawServicePorts alternate = HostAndServicePortsParser.parseOne((ObjectNode)it.getValue(), "ports");
            if (alternate.rawServicePorts.isEmpty()) {
                alternate = new HostAndRawServicePorts(alternate.host, defaultInfo.rawServicePorts);
            }
            result.put(network, alternate);
        });
        return result;
    }

    private static HostAndRawServicePorts parseOne(ObjectNode json, String portsFieldName) {
        String host = json.path("hostname").textValue();
        if (host == null) {
            throw new CouchbaseException("Couchbase server version is too old for this SDK; nodesExt entry is missing 'hostname' field.");
        }
        return new HostAndRawServicePorts(host, HostAndServicePortsParser.parseServices((ObjectNode)json.get(portsFieldName)));
    }

    private static Map<String, Integer> parseServices(@Nullable ObjectNode servicesNode) {
        return servicesNode == null ? Collections.emptyMap() : Mapper.convertValue((Object)servicesNode, MAP_STRING_TO_INT);
    }

    private static class HostAndRawServicePorts {
        private final String host;
        private final Map<String, Integer> rawServicePorts;

        public HostAndRawServicePorts(String host, Map<String, Integer> rawServicePorts) {
            this.host = Objects.requireNonNull(host);
            this.rawServicePorts = Objects.requireNonNull(rawServicePorts);
        }
    }
}

