/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.topology.AbstractBucketTopology;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.KetamaRing;
import com.couchbase.client.core.topology.MemcachedBucketTopology;
import com.couchbase.client.core.util.CbCollections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
class MemcachedBucketTopologyParser {
    private static final Logger log = LoggerFactory.getLogger(MemcachedBucketTopologyParser.class);

    MemcachedBucketTopologyParser() {
    }

    public static MemcachedBucketTopology parse(ObjectNode configNode, List<HostAndServicePorts> nodes, MemcachedHashingStrategy hashingStrategy) {
        String bucketName = configNode.path("name").asText();
        String uuid = configNode.path("uuid").asText();
        Set<BucketCapability> bucketCapabilities = AbstractBucketTopology.parseBucketCapabilities(configNode);
        List<HostAndServicePorts> nodesWithoutKetamaAuthority = CbCollections.filter(nodes, it -> it.ketamaAuthority() == null);
        if (!nodesWithoutKetamaAuthority.isEmpty()) {
            log.warn("These nodes can't participate in the ketama ring for Memcached bucket '{}' because they didn't advertise a non-TLS KV port: {}", (Object)RedactableArgument.redactMeta(bucketName), (Object)RedactableArgument.redactSystem(nodesWithoutKetamaAuthority));
        }
        List<HostAndServicePorts> ketamaNodes = CbCollections.filter(nodes, it -> it.ketamaAuthority() != null);
        KetamaRing<HostAndServicePorts> ketamaRing = KetamaRing.create(ketamaNodes, hashingStrategy);
        return new MemcachedBucketTopology(bucketName, uuid, bucketCapabilities, nodes, ketamaRing, hashingStrategy);
    }
}

